/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class WindWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WindWitchEntity> SPECIES;
    private int teleportDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(6523058).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureBaseOnly().addExperience(2).fallImmune().multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Wind Witch", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WindWitchEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42402_);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42584_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<WindWitchEntity> getVariantFactory() {
        return WindWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WindWitchEntity> getSpecies() {
        return SPECIES;
    }

    public WindWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((PathfinderMob)this, 1.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FluidPathNavigator((Mob)this, level, true, false);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13131_);
    }

    public void m_8119_() {
        super.m_8119_();
        MobHelper.floatInFluid((Entity)this, 0.06, (FluidType)ForgeMod.WATER_TYPE.get());
        MobHelper.hopOntoShore((Entity)this, (TagKey<Fluid>)FluidTags.f_13131_);
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.teleportDelay-- <= 0 && this.m_5448_() != null && this.f_19796_.m_188503_(20) == 0) {
            if (this.m_5448_().m_20280_((Entity)this) > 64.0) {
                for (int i = 0; i < 16; ++i) {
                    if (!this.teleportTowards((Entity)this.m_5448_())) continue;
                    this.teleportDelay = 60;
                    this.m_21195_(MobEffects.f_19609_);
                    break;
                }
            } else {
                MobHelper.applyDurationEffect((LivingEntity)this, MobEffects.f_19609_, 30);
                for (int i = 0; i < 16; ++i) {
                    if (!this.teleport()) continue;
                    this.teleportDelay = 30;
                    break;
                }
            }
        }
        super.m_8107_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || this.m_5825_() && source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && this.m_21223_() > 0.0f) {
            if (source.m_7639_() instanceof LivingEntity) {
                this.teleportDelay -= 15;
                if (this.teleportDelay <= 0 && this.f_19796_.m_188501_() < 0.5f) {
                    for (int i = 0; i < 16 && !this.teleport(); ++i) {
                    }
                } else {
                    this.m_21195_(MobEffects.f_19609_);
                }
            } else if (this.f_19796_.m_188503_(10) != 0) {
                this.teleport();
            }
        }
        return success;
    }

    protected boolean teleport() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 20.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(12) - 4);
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 20.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleportTowards(Entity target) {
        Vec3 directionFromTarget = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_()).m_82541_();
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - directionFromTarget.f_82479_ * 10.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(8) - 2) - directionFromTarget.f_82480_ * 10.0;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - directionFromTarget.f_82481_ * 10.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > 0) {
            BlockState block = this.m_9236_().m_8055_((BlockPos)pos);
            if (block.m_280555_() || block.m_60819_().m_205070_(FluidTags.f_13131_)) {
                EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)(y + 1.0), (double)z);
                if (event.isCanceled()) {
                    return false;
                }
                boolean success = this.uncheckedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
                if (success && !this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11923_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11923_, 1.0f, 1.0f);
                }
                return success;
            }
            pos.m_122173_(Direction.DOWN);
            y -= 1.0;
        }
        return false;
    }

    private boolean uncheckedTeleport(double x, double y, double z, boolean spawnParticles) {
        double xI = this.m_20185_();
        double yI = this.m_20186_();
        double zI = this.m_20189_();
        if (this.m_9236_().m_46805_(BlockPos.m_274561_((double)x, (double)y, (double)z))) {
            this.m_6021_(x, y, z);
            if (this.m_9236_().m_45786_((Entity)this) && !this.m_9236_().m_46855_(this.m_20191_())) {
                if (spawnParticles) {
                    References.EntityEvent.TELEPORT_TRAIL_PARTICLES.broadcast((LivingEntity)this);
                }
                this.m_21573_().m_26573_();
                return true;
            }
        }
        this.m_6021_(xI, yI, zI);
        return false;
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }
}

