/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class ShadowsWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ShadowsWitchEntity> SPECIES;
    private static final Collection<MobEffectInstance> POTION_SHADOWS;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(2).effectImmune(MobEffects.f_19610_, MobEffects.f_19615_);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch of Shadows", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ShadowsWitchEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42532_);
        loot.addRareDrop("rare", PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43603_));
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<ShadowsWitchEntity> getVariantFactory() {
        return ShadowsWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ShadowsWitchEntity> getSpecies() {
        return SPECIES;
    }

    public ShadowsWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (!(!(target.m_21223_() >= 4.0f) || target.m_21023_(MobEffects.f_19610_) && target.m_21023_(MobEffects.f_19615_))) {
            return this.makeSplashPotion(POTION_SHADOWS);
        }
        return originalPotion;
    }

    @Override
    public void m_8107_() {
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && target != null && target.m_21023_(MobEffects.f_19610_) && this.f_19796_.m_188503_(10) == 0) {
            MobHelper.removeNightVision(target);
        }
        super.m_8107_();
    }

    static {
        POTION_SHADOWS = Arrays.asList(new MobEffectInstance(MobEffects.f_19610_, 300, 0), new MobEffectInstance(MobEffects.f_19615_, 200, 0));
    }
}

