/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class IceWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<IceWitchEntity> SPECIES;
    private int wallDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(2).effectImmune(MobEffects.f_19597_).addToAttribute(Attributes.f_22284_, 10.0).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Ice Witch", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        IceWitchEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Items.f_42452_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50568_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<IceWitchEntity> getVariantFactory() {
        return IceWitchEntity::new;
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.WITCHES, EntityTypeTags.f_144294_);
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends IceWitchEntity> getSpecies() {
        return SPECIES;
    }

    public IceWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((PathfinderMob)this, 0.8);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FluidPathNavigator((Mob)this, level, true, false);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13131_);
    }

    public void m_8119_() {
        super.m_8119_();
        MobHelper.floatInFluid((Entity)this, 0.08, (FluidType)ForgeMod.WATER_TYPE.get());
        MobHelper.hopOnFluid((Entity)this);
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        MobHelper.updateFrostWalker((LivingEntity)this, pos);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (!target.m_21023_(MobEffects.f_19597_)) {
            return this.makeSplashPotion(Potions.f_43617_);
        }
        return originalPotion;
    }

    @Override
    public void m_8107_() {
        double distanceSq;
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.wallDelay-- <= 0 && target != null && this.f_19796_.m_188503_(20) == 0 && (distanceSq = target.m_20280_((Entity)this)) > 100.0 && distanceSq < 196.0 && target.m_21023_(MobEffects.f_19597_) && this.m_142582_((Entity)target)) {
            this.wallDelay = 200;
            Vec3 targetVec = target.m_20182_().m_82546_(this.m_20182_());
            if (target.m_5842_()) {
                this.buildIceSheet(target.m_20183_().m_122032_().m_122184_(0, (int)Math.ceil(target.m_20206_()) + 1, 0), 3);
            } else {
                this.buildIceWall(target.m_20183_().m_122032_(), Direction.m_122366_((double)targetVec.f_82479_, (double)0.0, (double)targetVec.f_82481_));
            }
        }
        super.m_8107_();
    }

    private void buildIceSheet(BlockPos.MutableBlockPos currentPos, int maxDiff) {
        int yI = currentPos.m_123342_();
        int maxY = Math.min(yI + maxDiff, this.m_9236_().m_151558_() - 2);
        while (currentPos.m_123342_() < maxY && this.m_9236_().m_46801_((BlockPos)currentPos)) {
            currentPos.m_122184_(0, 1, 0);
        }
        currentPos.m_122184_(0, -1, 0);
        BlockPos center = currentPos.m_7949_();
        int radius = 5;
        int radiusSq = 25;
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                int distSq = x * x + z * z;
                if (distSq > 25) continue;
                currentPos.m_122154_((Vec3i)center, x, 0, z);
                if (!this.shouldReplace((BlockPos)currentPos) || !MobHelper.placeBlock((Entity)this, (BlockPos)currentPos, MeltingIceBlock.getState(this.m_9236_(), (BlockPos)currentPos))) continue;
                MeltingIceBlock.scheduleFirstTick(this.m_9236_(), (BlockPos)currentPos, this.f_19796_);
            }
        }
        this.playSpellSound(center);
    }

    private void buildIceWall(BlockPos.MutableBlockPos currentPos, Direction forward) {
        Direction transverse = forward.m_122427_();
        currentPos.m_122175_(forward, 2);
        BlockPos center = currentPos.m_7949_();
        for (int tv = -4; tv < 4; ++tv) {
            currentPos.m_122190_((Vec3i)center).m_122175_(transverse, tv);
            this.placePillar((BlockPos)currentPos, 4);
        }
        this.playSpellSound(center);
    }

    private void placePillar(BlockPos pos, int maxDiff) {
        BlockPos.MutableBlockPos currentPos = pos.m_122032_();
        if (this.shouldReplace((BlockPos)currentPos)) {
            this.findGroundBelow(currentPos, maxDiff);
        } else if (this.findGroundAbove(currentPos, maxDiff)) {
            return;
        }
        int maxY = Math.min(currentPos.m_123342_() + 4, this.m_9236_().m_151558_() - 2);
        int height = -2;
        if (pos.m_123342_() > currentPos.m_123342_()) {
            height -= (pos.m_123342_() - currentPos.m_123342_()) / 2;
        }
        while (currentPos.m_123342_() < maxY && this.shouldReplace((BlockPos)currentPos)) {
            if (MobHelper.placeBlock((Entity)this, (BlockPos)currentPos, MeltingIceBlock.getState(this.m_9236_(), (BlockPos)currentPos))) {
                MeltingIceBlock.scheduleFirstTick(this.m_9236_(), (BlockPos)currentPos, this.f_19796_);
            }
            currentPos.m_122184_(0, 1, 0);
            if (++height < 0 || !this.f_19796_.m_188499_()) continue;
            break;
        }
    }

    private void findGroundBelow(BlockPos.MutableBlockPos currentPos, int maxDiff) {
        int yI = currentPos.m_123342_();
        int minY = Math.max(yI - maxDiff, 0);
        while (currentPos.m_123342_() > minY) {
            currentPos.m_122184_(0, -1, 0);
            if (this.shouldReplace((BlockPos)currentPos)) continue;
            currentPos.m_122184_(0, 1, 0);
            return;
        }
        currentPos.m_142448_(yI);
    }

    private boolean findGroundAbove(BlockPos.MutableBlockPos currentPos, int maxDiff) {
        int yI = currentPos.m_123342_();
        int maxY = Math.min(yI + maxDiff, this.m_9236_().m_151558_() - 2);
        while (currentPos.m_123342_() < maxY) {
            currentPos.m_122184_(0, 1, 0);
            if (!this.shouldReplace((BlockPos)currentPos)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldReplace(BlockPos pos) {
        BlockState stateAtPos = this.m_9236_().m_8055_(pos);
        return stateAtPos.m_247087_() || stateAtPos.m_204336_(BlockTags.f_13035_) || stateAtPos.m_60713_(Blocks.f_50449_);
    }

    private void playSpellSound(BlockPos pos) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11983_, this.m_5720_(), 0.4f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        }
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }
}

