/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.WebSpiderSpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

@SpecialMob
public class WebSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WebSpiderEntity> SPECIES;
    private int webCount;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE7E7E7).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(2).spitAttackMultiplied(0.1, 1.0, 2.0f, 1.0).addToAttribute(Attributes.f_22276_, 4.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new WebSpiderSpeciesConfig(manager, species, 0.02, 2, 6);
    }

    @Override
    public WebSpiderSpeciesConfig getConfig() {
        return (WebSpiderSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Weaver", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WebSpiderEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50033_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<WebSpiderEntity> getVariantFactory() {
        return WebSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WebSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public WebSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, Level level) {
        super(entityType, level);
        this.webCount = this.getConfig().WEB.webCount.next(this.f_19796_);
    }

    @Override
    protected int getVariantSpitColor() {
        return 0xFFFFFF;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        BlockPos pos;
        if (!this.m_9236_().m_5776_() && this.webCount > 0 && !(target instanceof Spider) && !this.tryPlaceWeb(pos = target.m_20183_()) && target.m_20206_() > 1.0f) {
            this.tryPlaceWeb(pos.m_7494_());
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean killedByPlayer) {
        super.m_7472_(source, looting, killedByPlayer);
        this.tryPlaceWeb(this.m_20183_());
    }

    private boolean tryPlaceWeb(BlockPos pos) {
        if (this.m_9236_().m_8055_(pos).m_247087_() && MobHelper.placeBlock((Entity)this, pos, Blocks.f_50033_.m_49966_())) {
            --this.webCount;
            return true;
        }
        return false;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Ammo", (byte)this.webCount);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Ammo", 99)) {
            this.webCount = saveTag.m_128445_("Ammo");
        }
    }
}

