/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class HungrySpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HungrySpiderEntity> SPECIES;
    private static final AttributeModifier DAMAGE_BOOST;
    private static final AttributeModifier HEALTH_BOOST;
    private int growthLevel;
    private int maxHealthStacks;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7969893).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureWithEyes().size(1.5f, 1.9f, 1.3f).addExperience(2).regen(40).disableRangedAttack().addToAttribute(Attributes.f_22276_, 4.0).addToAttribute(Attributes.f_22281_, -1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Hungry Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        HungrySpiderEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42500_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42410_, Items.f_42732_, Items.f_42583_, Items.f_42581_, Items.f_42697_, Items.f_42572_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<HungrySpiderEntity> getVariantFactory() {
        return HungrySpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HungrySpiderEntity> getSpecies() {
        return SPECIES;
    }

    public HungrySpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                ItemStack food = MobHelper.stealRandomFood(player);
                if (food.m_41619_()) return;
                float previousHealth = this.m_21233_();
                if (this.maxHealthStacks < 32) {
                    ++this.maxHealthStacks;
                }
                if (this.growthLevel < 7) {
                    ++this.growthLevel;
                }
                this.updateFeedingLevels();
                this.m_21153_(this.m_21223_() + this.m_21233_() - previousHealth);
                FoodProperties foodStats = food.m_41720_().getFoodProperties(food, (LivingEntity)this);
                this.m_5634_(Math.max(foodStats == null ? 0.0f : (float)foodStats.m_38744_(), 1.0f));
                this.m_5496_(SoundEvents.f_12321_, 0.5f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                return;
            }
        }
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    private void updateFeedingLevels() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            AttributeInstance health = this.m_21051_(Attributes.f_22276_);
            AttributeInstance damage = this.m_21051_(Attributes.f_22281_);
            health.m_22120_(HEALTH_BOOST.m_22209_());
            damage.m_22120_(DAMAGE_BOOST.m_22209_());
            if (this.maxHealthStacks > 0) {
                health.m_22125_(new AttributeModifier(HEALTH_BOOST.m_22209_(), HEALTH_BOOST.m_22214_(), HEALTH_BOOST.m_22218_() * (double)this.maxHealthStacks, HEALTH_BOOST.m_22217_()));
            }
            if (this.growthLevel > 0) {
                damage.m_22125_(new AttributeModifier(DAMAGE_BOOST.m_22209_(), DAMAGE_BOOST.m_22214_(), DAMAGE_BOOST.m_22218_() * (double)this.growthLevel, DAMAGE_BOOST.m_22217_()));
            }
        }
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("HealthStacks", (byte)this.maxHealthStacks);
        saveTag.m_128344_("GrowthLevel", (byte)this.growthLevel);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("HealthStacks", 99)) {
            this.maxHealthStacks = saveTag.m_128445_("HealthStacks");
        }
        if (saveTag.m_128425_("GrowthLevel", 99)) {
            this.growthLevel = saveTag.m_128445_("GrowthLevel");
        }
        this.updateFeedingLevels();
    }

    static {
        DAMAGE_BOOST = new AttributeModifier(UUID.fromString("70457CAB-AA09-4E1C-B44B-99DD4A2A836D"), "Feeding damage boost", 1.0, AttributeModifier.Operation.ADDITION);
        HEALTH_BOOST = new AttributeModifier(UUID.fromString("D22A70EF-7C71-4BC5-8B23-7045728FD84F"), "Feeding health boost", 2.0, AttributeModifier.Operation.ADDITION);
    }
}

