/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialLeapAtTargetGoal;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class GrapeSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<GrapeSlimeEntity> SPECIES;
    private static final ParticleOptions JUMP_PARTICLE;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xB333B3).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureBaseOnly().addExperience(1).fallImmune().addToAttribute(Attributes.f_22276_, 4.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Grape Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        GrapeSlimeEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (ItemLike)Items.f_42518_, 1);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42493_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<GrapeSlimeEntity> getVariantFactory() {
        return GrapeSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends GrapeSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public GrapeSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        this.f_21345_.m_25352_(0, (Goal)new SpecialLeapAtTargetGoal((Mob)this, 10, 6.0f, 12.0f, 1.1f, 2.6f));
    }

    protected ParticleOptions m_6300_() {
        return JUMP_PARTICLE;
    }

    static {
        JUMP_PARTICLE = new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42493_.m_7968_());
    }
}

