/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class BlueberrySlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<BlueberrySlimeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7760828).theme(BestiaryInfo.Theme.WATER).uniqueTextureBaseOnly().addExperience(1).drownImmune().fluidPushImmune().addToAttribute(Attributes.f_22281_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        SpeciesConfig.NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS = new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)manager, (float)0.0f).atNoMoonLight().build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.04f).atMaxMoonLight().build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.01f).belowHalfMoonLight().build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.02f).atHalfMoonLight().build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.03f).aboveHalfMoonLight().build()});
        return new SpeciesConfig(manager, species);
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends BlueberrySlimeEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, SpawnPlacements.Type.IN_WATER, BlueberrySlimeEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends BlueberrySlimeEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        Holder biome = level.m_204166_(pos);
        if (biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(BiomeTags.f_207603_)) {
            return NaturalSpawnManager.checkSpawnRulesWater(type, level, spawnType, pos, random);
        }
        return _SpecialSlimeEntity.checkFamilySpawnRules(type, level, spawnType, pos, random);
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Blueberry Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        BlueberrySlimeEntity.addBaseLoot(loot);
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42587_, Items.f_42695_, Items.f_42696_});
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42494_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<BlueberrySlimeEntity> getVariantFactory() {
        return BlueberrySlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends BlueberrySlimeEntity> getSpecies() {
        return SPECIES;
    }

    public BlueberrySlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.f_21345_, 1);
    }

    public void m_8119_() {
        float range;
        double dZ;
        double dX;
        super.m_8119_();
        double floatAccel = 0.06;
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_20227_(0.5) < this.m_20227_(0.5) && (dX = target.m_20185_() - this.m_20185_()) * dX + (dZ = target.m_20189_() - this.m_20189_()) * dZ < (double)((range = (target.m_20205_() + this.m_20205_() + 0.1f) / 2.0f) * range)) {
            floatAccel = -0.12;
        }
        if (this.f_19797_ > 1 && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > 0.0 && (!CollisionContext.m_82750_((Entity)this).m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) || this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_))) {
            this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, floatAccel, 0.0));
        }
    }

    public boolean m_20070_() {
        return true;
    }

    public boolean m_20071_() {
        return true;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123769_;
    }
}

