/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.SkeletonFamilyConfig;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialSkeletonEntity
extends AbstractSkeleton
implements ISpecialMob<_SpecialSkeletonEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialSkeletonEntity> SPECIES;
    protected static final double DEFAULT_BOW_CHANCE = 0.95;
    protected static final double DEFAULT_SHIELD_CHANCE = 0.05;
    private static final EntityDataAccessor<Float> SCALE;
    protected Goal currentAttackAI;
    private static final EntityDataAccessor<Boolean> IS_BABY;
    private SpecialMobData<_SpecialSkeletonEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x494949).modBaseTexture("textures/entity/skeleton/base_skeleton.png").experience(5).undead().bowAttack(2.0, 1.0, 1.0, 20, 15.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(manager, species, 0.95, 0.05);
    }

    public SkeletonSpeciesConfig getConfig() {
        return (SkeletonSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_32166_() {
        return Skeleton.m_32166_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialSkeletonEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Skeleton", "Esqueleto", "Esqueleto", "Squelette", "Scheletro", "Skelett", "Bag o' Bones");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20524_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return Collections.singletonList(EntityTypeTags.f_13120_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialSkeletonEntity> getFactory() {
        return _SpecialSkeletonEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    protected int getVariantAttackPriority() {
        return 4;
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_6504_(LivingEntity target, float damageMulti) {
        ItemStack arrowItem = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = this.m_7932_(arrowItem, damageMulti);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
        }
        double dX = target.m_20185_() - this.m_20185_();
        double dY = target.m_20227_(0.3333) - arrow.m_20186_();
        double dZ = target.m_20189_() - this.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        arrow.m_6686_(dX, dY + dH * 0.2, dZ, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - 4 * this.m_9236_().m_46791_().m_19028_()));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    protected AbstractArrow m_7932_(ItemStack arrowItem, float damageMulti) {
        return this.getVariantArrow(super.m_7932_(arrowItem, damageMulti * this.getSpecialData().getRangedAttackDamage() / 2.0f), arrowItem, damageMulti);
    }

    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return arrow;
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, Level level) {
        super(entityType, level);
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialSkeletonEntity>(this, SCALE);
        this.f_19804_.m_135372_(IS_BABY, (Object)false);
    }

    public void m_32164_() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            if (this.currentAttackAI != null) {
                this.f_21345_.m_25363_(this.currentAttackAI);
            }
            SpecialMobData<_SpecialSkeletonEntity> data = this.getSpecialData();
            ItemStack weapon = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            this.currentAttackAI = data.getRangedAttackMaxRange() > 0.0f && weapon.m_41720_() == Items.f_42411_ ? new RangedBowAttackGoal((Monster)this, (double)data.getRangedWalkSpeed(), data.getRangedAttackCooldown(), data.getRangedAttackMaxRange()) : new MeleeAttackGoal((PathfinderMob)this, 1.2, false);
            this.f_21345_.m_25352_(this.getVariantAttackPriority(), this.currentAttackAI);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12383_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean killedByPlayer) {
        Creeper creeper;
        super.m_7472_(source, looting, killedByPlayer);
        Entity entity = source.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            creeper.m_32314_();
            this.m_19998_((ItemLike)Items.f_42678_);
        }
    }

    public void m_6863_(boolean value) {
        this.m_20088_().m_135381_(IS_BABY, (Object)value);
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
            attributeInstance.m_22130_(References.BABY_SPEED_BOOST);
            if (value) {
                attributeInstance.m_22118_(References.BABY_SPEED_BOOST);
            }
        }
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(IS_BABY);
    }

    public void m_7350_(EntityDataAccessor<?> parameter) {
        if (IS_BABY.equals(parameter)) {
            this.m_6210_();
        }
        super.m_7350_(parameter);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((float)this.f_21364_ * 2.5f);
        }
        return super.m_213860_();
    }

    public double m_6049_() {
        return super.m_6049_() + (this.m_6162_() ? 0.45 : 0.0);
    }

    @Override
    public SpecialMobData<_SpecialSkeletonEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes type, float malus) {
        this.m_21441_(type, malus);
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.m_6863_(((SkeletonFamilyConfig)((Object)MobFamily.SKELETON.config)).SKELETONS.babyChance.rollChance(this.f_19796_));
        if (this.getSpecialData().getRangedAttackMaxRange() <= 0.0f || !this.getConfig().SKELETONS.bowEquipChance.rollChance(this.f_19796_)) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            if (this.getConfig().SKELETONS.shieldEquipChance.rollChance(this.f_19796_)) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
            }
        }
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
        this.m_32164_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (this.m_6126_() && entity instanceof Snowball) {
            amount = Math.max(3.0f, amount);
        }
        if (amount > 0.0f && MobHelper.tryBlockAttack((LivingEntity)this, source, true)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.m_128379_("IsBaby", this.m_6162_());
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.m_128425_("IsBaby", 99)) {
            this.m_6863_(saveTag.m_128471_("IsBaby"));
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.m_32164_();
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        IS_BABY = SynchedEntityData.m_135353_(_SpecialSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

