/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.IBoatRider;
import fathertoast.specialmobs.common.entity.ai.goal.ControlBoatGoal;
import fathertoast.specialmobs.common.entity.ai.goal.PirateSpawnBoatGoal;
import fathertoast.specialmobs.common.entity.misc.MobBoat;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PirateSkeletonEntity
extends _SpecialSkeletonEntity
implements IBoatRider {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<PirateSkeletonEntity> SPECIES;
    public static final EntityDataAccessor<Boolean> SPAWNED_BOAT;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).weight(BestiaryInfo.DefaultWeight.DISABLED).modBaseTexture("textures/entity/skeleton/base_skeleton.png").uniqueOverlayTexture().addExperience(3).addToAttribute(Attributes.f_22276_, 15.0).addToAttribute(Attributes.f_22277_, 40.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Pirate Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        PirateSkeletonEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42587_, 3);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42676_);
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42417_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<PirateSkeletonEntity> getVariantFactory() {
        return PirateSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends PirateSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialSkeletonEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, SpawnPlacements.Type.NO_RESTRICTIONS, PirateSkeletonEntity::checkPirateSkeletonSpawnRules);
    }

    private static boolean checkPirateSkeletonSpawnRules(EntityType<? extends _SpecialSkeletonEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean isDarkEnough = Monster.m_219009_((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random);
        return isDarkEnough && pos.m_123342_() <= level.m_5736_() && level.m_8055_(pos).m_60795_() && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public PirateSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWNED_BOAT, (Object)false);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, MobEffects.f_19619_);
    }

    @Override
    protected void registerVariantGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PirateSpawnBoatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ControlBoatGoal((Mob)this, 512.0, 256.0));
        AIHelper.replaceWaterAvoidingRandomWalking((PathfinderMob)this, 1.0);
    }

    @Override
    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_214095_(level.m_213780_(), difficulty.m_19057_());
    }

    public void onRemovedFromWorld() {
        Entity entity;
        if (this.m_146911_() == Entity.RemovalReason.DISCARDED && (entity = this.m_20202_()) instanceof MobBoat) {
            MobBoat mobBoat = (MobBoat)entity;
            mobBoat.m_146870_();
        }
    }

    public boolean m_8023_() {
        return false;
    }

    static {
        SPAWNED_BOAT = SynchedEntityData.m_135353_(PirateSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

