/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class FireSilverfishEntity
extends _SpecialSilverfishEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireSilverfishEntity> SPECIES;
    private byte auraCooldown = (byte)20;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14656027).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(2).fireImmune();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Firebrat", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireSilverfishEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42413_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.SILVERFISH, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FireSilverfishEntity> getVariantFactory() {
        return FireSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public FireSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected int getVariantSpitColor() {
        return 14656027;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.m_20254_(5);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        byte by = this.auraCooldown;
        this.auraCooldown = (byte)(by - 1);
        if (by <= 0) {
            this.auraCooldown = (byte)30;
            this.pulseAura();
        }
    }

    private void pulseAura() {
        List friends = this.m_9236_().m_45976_(Silverfish.class, this.m_20191_().m_82400_(7.0));
        for (Silverfish cutie : friends) {
            if (!cutie.m_6084_() || cutie.m_5825_()) continue;
            cutie.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 35 + this.f_19796_.m_188503_(16), 0, true, true));
        }
    }
}

