/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.projectile;

import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class SpecialFishingBobberEntity
extends Projectile
implements IEntityAdditionalSpawnData {
    private static final float DRAG_FACTOR = 0.92f;
    private static final float GRAVITY_ACCEL = 0.03f;
    private float maxRangeSq = 1024.0f;

    public SpecialFishingBobberEntity(EntityType<? extends SpecialFishingBobberEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SpecialFishingBobberEntity(LivingEntity angler, LivingEntity target) {
        super((EntityType)SMEntities.FISHING_BOBBER.get(), angler.m_9236_());
        this.m_5602_((Entity)angler);
        Vec3 lookVec = angler.m_20252_(1.0f).m_82490_((double)angler.m_20205_());
        this.m_6034_(angler.m_20185_() + lookVec.f_82479_, angler.m_20188_() - 0.1, angler.m_20189_() + lookVec.f_82481_);
        float spread = 18 - 4 * this.m_9236_().m_46791_().m_19028_();
        if (angler instanceof ISpecialMob) {
            ISpecialMob specialShooter = (ISpecialMob)angler;
            if (specialShooter.getSpecialData().getRangedAttackMaxRange() >= 0.0f) {
                this.maxRangeSq = 2.0f * specialShooter.getSpecialData().getRangedAttackMaxRange();
                this.maxRangeSq *= this.maxRangeSq;
            } else {
                SpecialMobs.LOG.warn("Entity is shooting projectile, but has no max range stat! {}", (Object)angler);
            }
            if (specialShooter.getSpecialData().getRangedAttackSpread() >= 0.0f) {
                spread *= specialShooter.getSpecialData().getRangedAttackSpread();
            } else {
                SpecialMobs.LOG.warn("Entity is shooting projectile, but has no ranged spread stat! {}", (Object)angler);
            }
        }
        double dX = target.m_20185_() - this.m_20185_();
        double dY = target.m_20227_(0.3333) - this.m_20186_();
        double dZ = target.m_20189_() - this.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        this.m_6686_(dX, dY + dH * 0.2, dZ, 1.3f, spread);
    }

    protected void m_8097_() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity owner = this.m_19749_();
        buffer.writeInt(owner == null ? 0 : owner.m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int ownerId = additionalData.readInt();
        this.m_5602_(this.m_9236_().m_6815_(ownerId));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        AABB boundingBox = super.m_6921_();
        Entity owner = this.m_19749_();
        return owner == null ? boundingBox : boundingBox.m_82367_(owner.m_6921_());
    }

    @Nullable
    public LivingEntity getLivingOwner() {
        Entity owner = this.m_19749_();
        return owner instanceof LivingEntity ? (LivingEntity)owner : null;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity angler = this.getLivingOwner();
        if (!this.m_9236_().m_5776_() && (angler == null || this.m_20280_((Entity)angler) > (double)this.maxRangeSq)) {
            this.m_146870_();
            return;
        }
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitResult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_(hitResult);
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.m_20072_() ? (double)0.06f : (double)-0.03f, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_37283_();
        this.m_20256_(this.m_20184_().m_82490_((double)0.92f));
        this.m_20090_();
    }

    protected void m_6532_(HitResult hit) {
        super.m_6532_(hit);
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        this.m_5496_(SoundEvents.f_11939_, 1.0f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        MobHelper.pull(this.m_19749_(), hit.m_82443_(), 0.32);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("MaxRange", this.maxRangeSq);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("MaxRange", 99)) {
            this.maxRangeSq = tag.m_128457_("MaxRange");
        }
    }
}

