/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.misc;

import com.google.common.collect.Lists;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.ai.IBoatRider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class MobBoat
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(MobBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final float[] paddlePositions = new float[2];
    private float invFriction;
    private float outOfControlTicks;
    public float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private double waterLevel;
    private float landFriction;
    private Status status;
    private Status oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;
    private int timeExistedNoPassengers;

    public MobBoat(EntityType<? extends MobBoat> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
    }

    public MobBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends MobBoat>)((EntityType)SMEntities.MOB_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public static Boat copyFromMobBoat(MobBoat mobBoat) {
        Boat boat = new Boat(mobBoat.m_9236_(), mobBoat.m_20185_(), mobBoat.m_20186_(), mobBoat.m_20189_());
        boat.m_146926_(mobBoat.m_146909_());
        boat.m_146922_(mobBoat.m_146908_());
        boat.f_19854_ = mobBoat.f_19854_;
        boat.f_19855_ = mobBoat.f_19855_;
        boat.f_19856_ = mobBoat.f_19856_;
        boat.f_38266_ = mobBoat.deltaRotation;
        boat.m_28464_(mobBoat.getVariant());
        return boat;
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Boat.Type.OAK.ordinal());
        this.f_19804_.m_135372_(DATA_ID_PADDLE_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_PADDLE_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_BUBBLE_TIME, (Object)0);
    }

    public boolean m_7337_(Entity entity) {
        return Boat.m_38323_((Entity)this, (Entity)entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle rectangle) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axis, rectangle));
    }

    public double m_6048_() {
        return this.getVariant() == Boat.Type.BAMBOO ? 0.25 : -0.1;
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource damageSource, float damage) {
        block5: {
            if (this.m_6673_(damageSource)) {
                return false;
            }
            if (this.m_9236_().f_46443_ || this.m_213877_()) break block5;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + damage * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
            var5_3 = damageSource.m_7639_();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = instabreak = false;
            }
            if (instabreak || this.getDamage() > 40.0f) {
                if (!instabreak && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.destroy(damageSource);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    protected void destroy(DamageSource damageSource) {
        this.m_19998_((ItemLike)this.getDropItem());
    }

    public void m_6845_(boolean dragDown) {
        if (!this.m_9236_().f_46443_) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = dragDown;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(60);
            }
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
            this.m_146852_(GameEvent.f_157784_, (Entity)this.m_6688_());
        }
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof Boat || entity instanceof MobBoat) {
            if (entity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entity);
            }
        } else if (entity.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(entity);
        }
    }

    public Item getDropItem() {
        return switch (this.getVariant()) {
            case Boat.Type.SPRUCE -> Items.f_42742_;
            case Boat.Type.BIRCH -> Items.f_42743_;
            case Boat.Type.JUNGLE -> Items.f_42744_;
            case Boat.Type.ACACIA -> Items.f_42745_;
            case Boat.Type.CHERRY -> Items.f_271386_;
            case Boat.Type.DARK_OAK -> Items.f_42746_;
            case Boat.Type.MANGROVE -> Items.f_220204_;
            case Boat.Type.BAMBOO -> Items.f_244624_;
            default -> Items.f_42453_;
        };
    }

    public void m_6053_(float yaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_6453_(double lerpX, double lerpY, double lerpZ, float lerpYRot, float lerpXRot, int i, boolean b) {
        this.lerpX = lerpX;
        this.lerpY = lerpY;
        this.lerpZ = lerpZ;
        this.lerpYRot = lerpYRot;
        this.lerpXRot = lerpXRot;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    protected void m_20351_(Entity entity) {
        super.m_20351_(entity);
        if (entity instanceof IBoatRider && entity.m_146911_() == Entity.RemovalReason.DISCARDED) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.m_9236_().f_46443_ && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        if (this.m_6688_() != null) {
            this.floatBoat();
            if (!this.m_9236_().f_46443_) {
                this.controlBoat();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.timeExistedNoPassengers > 60) {
            this.m_20153_();
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                Boat boat = MobBoat.copyFromMobBoat(this);
                this.m_9236_().m_7967_((Entity)boat);
                return;
            }
            return;
        }
        this.tickBubbleColumn();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent paddleSound;
                if (!this.m_20067_() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.paddlePositions[i] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (paddleSound = this.getPaddleSound()) != null) {
                    Vec3 viewVec = this.m_20252_(1.0f);
                    double xOffset = i == 1 ? -viewVec.f_82481_ : viewVec.f_82481_;
                    double zOffset = i == 1 ? viewVec.f_82479_ : -viewVec.f_82479_;
                    this.m_9236_().m_6263_(null, this.m_20185_() + xOffset, this.m_20186_(), this.m_20189_() + zOffset, paddleSound, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                }
                int n = i;
                this.paddlePositions[n] = this.paddlePositions[n] + 0.3926991f;
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.m_20101_();
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.2, -0.01, 0.2), EntitySelector.m_20421_((Entity)this));
        if (!nearbyEntities.isEmpty()) {
            for (Entity entity : nearbyEntities) {
                if (entity.m_20363_((Entity)this)) continue;
                if (!this.m_9236_().f_46443_ && this.m_20197_().size() < this.getMaxPassengers() && !entity.m_20159_() && this.hasEnoughSpaceFor(entity) && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.timeExistedNoPassengers = this.m_20197_().isEmpty() ? ++this.timeExistedNoPassengers : 0;
        }
    }

    private void tickBubbleColumn() {
        if (this.m_9236_().f_46443_) {
            this.bubbleMultiplier = this.getBubbleTime() > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = Mth.m_14036_((float)this.bubbleMultiplier, (float)0.0f, (float)1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5f * (float)this.m_9236_().m_46467_()) * this.bubbleMultiplier;
        } else {
            int bubbleTime;
            if (!this.isAboveBubbleColumn) {
                this.setBubbleTime(0);
            }
            if ((bubbleTime = this.getBubbleTime()) > 0) {
                this.setBubbleTime(--bubbleTime);
                int j = 60 - bubbleTime - 1;
                if (j > 0 && bubbleTime == 0) {
                    this.setBubbleTime(0);
                    Vec3 vec3 = this.m_20184_();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.m_20256_(vec3.m_82520_(0.0, -0.7, 0.0));
                        this.m_20153_();
                    } else {
                        this.m_20334_(vec3.f_82479_, this.m_146862_(entity -> entity instanceof Player) ? 2.7 : 0.6, vec3.f_82481_);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        return switch (this.getStatus()) {
            case Status.IN_WATER, Status.UNDER_WATER, Status.UNDER_FLOWING_WATER -> SoundEvents.f_11707_;
            case Status.ON_LAND -> SoundEvents.f_11706_;
            default -> null;
        };
    }

    private void tickLerp() {
        if (this.m_6688_() != null && !this.m_9236_().f_46443_) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double x = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double y = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double z = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double yRot = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)yRot / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(x, y, z);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void setPaddleState(boolean paddleLeft, boolean paddleRight) {
        this.f_19804_.m_135381_(DATA_ID_PADDLE_LEFT, (Object)paddleLeft);
        this.f_19804_.m_135381_(DATA_ID_PADDLE_RIGHT, (Object)paddleRight);
    }

    public float getRowingTime(int paddleIndex, float limbSwing) {
        return this.getPaddleState(paddleIndex) ? Mth.m_144920_((float)(this.paddlePositions[paddleIndex] - 0.3926991f), (float)this.paddlePositions[paddleIndex], (float)limbSwing) : 0.0f;
    }

    private Status getStatus() {
        Status status = this.isUnderwater();
        if (status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float friction = this.getGroundFriction();
        if (friction > 0.0f) {
            this.landFriction = friction;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB boundingBox = this.m_20191_();
        int minX = Mth.m_14107_((double)boundingBox.f_82288_);
        int maxX = Mth.m_14165_((double)boundingBox.f_82291_);
        int maxY = Mth.m_14107_((double)boundingBox.f_82292_);
        int minY = Mth.m_14165_((double)(boundingBox.f_82292_ - this.lastYd));
        int minZ = Mth.m_14107_((double)boundingBox.f_82290_);
        int maxZ = Mth.m_14165_((double)boundingBox.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (int y = maxY; y < minY; ++y) {
            float waterLevel = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.m_122178_(x, y, z);
                    FluidState fluidState = this.m_9236_().m_6425_((BlockPos)pos);
                    if (fluidState.m_192917_((Fluid)Fluids.f_76193_)) {
                        waterLevel = Math.max(waterLevel, fluidState.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)pos));
                    }
                    if (waterLevel >= 1.0f) continue block0;
                }
            }
            if (!(waterLevel < 1.0f)) continue;
            return (float)pos.m_123342_() + waterLevel;
        }
        return minY + 1;
    }

    public float getGroundFriction() {
        AABB boundingBox = this.m_20191_();
        boundingBox.m_165887_(boundingBox.f_82289_ - 0.001);
        int minX = Mth.m_14107_((double)boundingBox.f_82288_) - 1;
        int maxX = Mth.m_14165_((double)boundingBox.f_82291_) + 1;
        int minY = Mth.m_14107_((double)boundingBox.f_82289_) - 1;
        int maxY = Mth.m_14165_((double)boundingBox.f_82292_) + 1;
        int minZ = Mth.m_14107_((double)boundingBox.f_82290_) - 1;
        int maxZ = Mth.m_14165_((double)boundingBox.f_82293_) + 1;
        VoxelShape voxelShape = Shapes.m_83064_((AABB)boundingBox);
        float friction = 0.0f;
        int collisionAmount = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                int c = (x != minX && x != maxX - 1 ? 0 : 1) + (z != minZ && z != maxZ - 1 ? 0 : 1);
                if (c == 2) continue;
                for (int y = minY; y < maxY; ++y) {
                    if (c > 0 && (y == minY || y == maxY - 1)) continue;
                    pos.m_122178_(x, y, z);
                    BlockState state = this.m_9236_().m_8055_((BlockPos)pos);
                    if (state.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)pos).m_83216_((double)x, (double)y, (double)z), (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    friction += state.getFriction((LevelReader)this.m_9236_(), (BlockPos)pos, (Entity)this);
                    ++collisionAmount;
                }
            }
        }
        return friction / (float)collisionAmount;
    }

    private boolean checkInWater() {
        AABB boundingBox = this.m_20191_();
        int minX = Mth.m_14107_((double)boundingBox.f_82288_);
        int maxX = Mth.m_14165_((double)boundingBox.f_82291_);
        int minY = Mth.m_14107_((double)boundingBox.f_82289_);
        int maxY = Mth.m_14165_((double)(boundingBox.f_82289_ + 0.001));
        int minZ = Mth.m_14107_((double)boundingBox.f_82290_);
        int maxZ = Mth.m_14165_((double)boundingBox.f_82293_);
        boolean inWater = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.m_122178_(x, y, z);
                    FluidState fluidState = this.m_9236_().m_6425_((BlockPos)pos);
                    if (!fluidState.m_192917_((Fluid)Fluids.f_76193_)) continue;
                    float fluidY = (float)y + fluidState.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)pos);
                    this.waterLevel = Math.max((double)fluidY, this.waterLevel);
                    inWater |= boundingBox.f_82289_ < (double)fluidY;
                }
            }
        }
        return inWater;
    }

    @Nullable
    private Status isUnderwater() {
        AABB boundingBox = this.m_20191_();
        int minX = Mth.m_14107_((double)boundingBox.f_82288_);
        int maxX = Mth.m_14165_((double)boundingBox.f_82291_);
        int minY = Mth.m_14107_((double)boundingBox.f_82292_);
        double minYOffset = boundingBox.f_82292_ + 0.001;
        int maxY = Mth.m_14165_((double)minYOffset);
        int minZ = Mth.m_14107_((double)boundingBox.f_82290_);
        int maxZ = Mth.m_14165_((double)boundingBox.f_82293_);
        boolean isUnderwater = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.m_122178_(x, y, z);
                    FluidState fluidState = this.m_9236_().m_6425_((BlockPos)pos);
                    if (!fluidState.m_192917_((Fluid)Fluids.f_76193_) || !(minYOffset < (double)((float)pos.m_123342_() + fluidState.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)pos)))) continue;
                    if (!fluidState.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    isUnderwater = true;
                }
            }
        }
        return isUnderwater ? Status.UNDER_WATER : null;
    }

    private void floatBoat() {
        double flowingSpeed = this.m_20068_() ? 0.0 : (double)-0.04f;
        double underwaterSpeed = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                underwaterSpeed = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                flowingSpeed = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                underwaterSpeed = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.m_6688_() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 deltaMovement = this.m_20184_();
            this.m_20334_(deltaMovement.f_82479_ * (double)this.invFriction, deltaMovement.f_82480_ + flowingSpeed, deltaMovement.f_82481_ * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (underwaterSpeed > 0.0) {
                Vec3 newDeltaMovement = this.m_20184_();
                this.m_20334_(newDeltaMovement.f_82479_, (newDeltaMovement.f_82480_ + underwaterSpeed * 0.06153846016296973) * 0.75, newDeltaMovement.f_82481_);
            }
        }
    }

    public void controlBoat() {
        if (this.m_20160_()) {
            float momentum = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                momentum += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            if (this.inputUp) {
                momentum += 0.04f;
            }
            if (this.inputDown) {
                momentum -= 0.005f;
            }
            Vec3 deltaMovement = this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * momentum), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * momentum));
            this.m_20256_(deltaMovement);
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public boolean hasEnoughSpaceFor(Entity entity) {
        return entity.m_20205_() < this.m_20205_();
    }

    protected void m_19956_(Entity rider, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(rider)) {
            float xOffset = this.getSinglePassengerXOffset();
            float yOffset = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + rider.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(rider);
                xOffset = i == 0 ? 0.2f : -0.6f;
                if (rider instanceof Animal) {
                    xOffset += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3((double)xOffset, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            moveFunction.m_20372_(rider, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)yOffset, this.m_20189_() + vec3.f_82481_);
            rider.m_146922_(rider.m_146908_() + this.deltaRotation);
            rider.m_5616_(rider.m_6080_() + this.deltaRotation);
            this.clampRotation(rider);
            if (rider instanceof Animal) {
                Animal animal = (Animal)rider;
                if (this.m_20197_().size() == this.getMaxPassengers()) {
                    int sorcery = rider.m_19879_() % 2 == 0 ? 90 : 270;
                    rider.m_5618_(animal.f_20883_ + (float)sorcery);
                    rider.m_5616_(rider.m_6080_() + (float)sorcery);
                }
            }
        }
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 vec3 = MobBoat.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)passenger.m_20205_(), (float)passenger.m_146908_());
        double x = this.m_20185_() + vec3.f_82479_;
        double z = this.m_20189_() + vec3.f_82481_;
        BlockPos pos = BlockPos.m_274561_((double)x, (double)this.m_20191_().f_82292_, (double)z);
        BlockPos belowPos = pos.m_7495_();
        if (!this.m_9236_().m_46801_(belowPos)) {
            double belowFloorHeight;
            ArrayList dismountLocations = Lists.newArrayList();
            double floorHeight = this.m_9236_().m_45573_(pos);
            if (DismountHelper.m_38439_((double)floorHeight)) {
                dismountLocations.add(new Vec3(x, (double)pos.m_123342_() + floorHeight, z));
            }
            if (DismountHelper.m_38439_((double)(belowFloorHeight = this.m_9236_().m_45573_(belowPos)))) {
                dismountLocations.add(new Vec3(x, (double)belowPos.m_123342_() + belowFloorHeight, z));
            }
            for (Pose pose : passenger.m_7431_()) {
                for (Vec3 location : dismountLocations) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)location, (LivingEntity)passenger, (Pose)pose)) continue;
                    passenger.m_20124_(pose);
                    return location;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity entity) {
        this.clampRotation(entity);
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128359_("Type", this.getVariant().m_7912_());
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128425_("Type", 8)) {
            this.setVariant(Boat.Type.m_38432_((String)compoundTag.m_128461_("Type")));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.m_9236_().f_46443_) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7840_(double yVelocity, boolean onGround, BlockState state, BlockPos pos) {
        this.lastYd = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getVariant().m_38434_());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.m_9236_().m_6425_(this.m_20183_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && yVelocity < 0.0) {
                this.f_19789_ -= (float)yVelocity;
            }
        }
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.f_19804_.m_135370_(side == 0 ? DATA_ID_PADDLE_LEFT : DATA_ID_PADDLE_RIGHT) != false && this.m_6688_() != null;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int hurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)hurtTime);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    private void setBubbleTime(int bubbleTime) {
        this.f_19804_.m_135381_(DATA_ID_BUBBLE_TIME, (Object)bubbleTime);
    }

    private int getBubbleTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_BUBBLE_TIME);
    }

    public float getBubbleAngle(float f) {
        return Mth.m_14179_((float)f, (float)this.bubbleAngleO, (float)this.bubbleAngle);
    }

    public void setHurtDir(int hurtDir) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)hurtDir);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setVariant(Boat.Type type) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public Boat.Type getVariant() {
        return Boat.Type.m_38430_((int)((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE)));
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < this.getMaxPassengers() && this.getEyeInFluidType() != ForgeMod.WATER_TYPE.get();
    }

    protected int getMaxPassengers() {
        return 2;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingEntity;
        Entity entity = this.m_146895_();
        LivingEntity captain = entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
        return captain;
    }

    public void setInput(boolean left, boolean right, boolean forward, boolean backward) {
        this.inputLeft = left;
        this.inputRight = right;
        this.inputUp = forward;
        this.inputDown = backward;
    }

    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

