/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.magmacube;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.ai.IExplodingMob;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialSwellGoal;
import fathertoast.specialmobs.common.entity.magmacube._SpecialMagmaCubeEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class VolatileMagmaCubeEntity
extends _SpecialMagmaCubeEntity
implements IExplodingMob {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<VolatileMagmaCubeEntity> SPECIES;
    private static final byte MAX_FUSE = 30;
    private int fuse = 0;
    private boolean ignited = false;
    private int swellDir = 0;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x331133).uniqueTextureBaseOnly().addExperience(2).addToAttribute(Attributes.f_22276_, 2.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Volatile Magma Cube", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        VolatileMagmaCubeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42403_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<VolatileMagmaCubeEntity> getVariantFactory() {
        return VolatileMagmaCubeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends VolatileMagmaCubeEntity> getSpecies() {
        return SPECIES;
    }

    public VolatileMagmaCubeEntity(EntityType<? extends _SpecialMagmaCubeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        this.f_21345_.m_25352_(0, new SpecialSwellGoal<VolatileMagmaCubeEntity>(this));
    }

    public void m_8119_() {
        if (this.m_6084_() && !this.m_9236_().m_5776_()) {
            if (this.ignited) {
                this.m_32283_(1);
            }
            if (this.m_32310_() > 0) {
                if (this.fuse == 0) {
                    this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                } else if (this.fuse >= 30) {
                    this.f_20890_ = true;
                    ExplosionHelper.explode((Entity)this, (float)this.m_33632_() + 0.5f, true, false);
                    this.m_146870_();
                    this.spawnLingeringCloud();
                }
                this.changeFuse(1);
            } else if (this.m_32310_() < 0 && this.fuse > 0) {
                this.changeFuse(-1);
                if (this.fuse <= 0) {
                    this.m_32283_(0);
                }
            }
        }
        super.m_8119_();
    }

    private void changeFuse(int change) {
        this.fuse += change;
        this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() + (float)change * 0.014f);
    }

    protected void spawnLingeringCloud() {
        ArrayList effects = new ArrayList(this.m_21220_());
        if (!effects.isEmpty()) {
            AreaEffectCloud potionCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            potionCloud.m_19712_((float)this.m_33632_() + 0.5f);
            potionCloud.m_19732_(-0.5f);
            potionCloud.m_19740_(10);
            potionCloud.m_19734_(potionCloud.m_19748_() / 2);
            potionCloud.m_19738_(-potionCloud.m_19743_() / (float)potionCloud.m_19748_());
            for (MobEffectInstance effect : effects) {
                potionCloud.m_19716_(new MobEffectInstance(effect));
            }
            this.m_9236_().m_7967_((Entity)potionCloud);
        }
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        boolean success = super.m_142535_(distance, damageMultiplier, damageSource);
        if (this.m_5639_(distance, damageMultiplier) > 0) {
            this.changeFuse((int)(distance * 1.5f));
            if (this.fuse > 25) {
                this.changeFuse(25 - this.fuse);
            }
        }
        return success;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_() == Items.f_42409_) {
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.ignited = true;
                item.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("FuseTime", (byte)this.fuse);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("FuseTime", 99)) {
            this.fuse = saveTag.m_128445_("FuseTime");
        }
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123762_;
    }

    @Override
    public void m_32283_(int value) {
        this.swellDir = value;
    }

    @Override
    public int m_32310_() {
        return this.swellDir;
    }

    @Override
    public double getExtraRange() {
        return (float)(this.m_33632_() - 1) * 2.0f;
    }
}

