/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class UnholyGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<UnholyGhastEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(8046420).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithAnimation().size(0.5f, 2.0f, 2.0f).addExperience(4).undead().disableRangedAttack().addToAttribute(Attributes.f_22276_, 10.0).addToAttribute(Attributes.f_22281_, 2.0).multiplyAttribute(Attributes.f_22279_, 0.7);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Unholy Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        UnholyGhastEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42500_);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42692_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<UnholyGhastEntity> getVariantFactory() {
        return UnholyGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends UnholyGhastEntity> getSpecies() {
        return SPECIES;
    }

    public UnholyGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (MobHelper.isDamageSourceIneffectiveAgainstVampires(source)) {
            amount = Math.min(2.0f, amount);
        }
        return super.m_6469_(source, amount += MobHelper.getVampireDamageBonus(source));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public void m_8107_() {
        if (this.m_21527_()) {
            ItemStack hat = this.m_6844_(EquipmentSlot.HEAD);
            if (!hat.m_41619_()) {
                if (hat.m_41763_()) {
                    hat.m_41721_(hat.m_41773_() + this.f_19796_.m_188503_(2));
                    if (hat.m_41773_() >= hat.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
            } else {
                this.m_20254_(8);
            }
        }
        super.m_8107_();
    }
}

