/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.QueenGhastSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ghast.BabyGhastEntity;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class QueenGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<QueenGhastEntity> SPECIES;
    private int babies;
    private int summons;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(13503231).uniqueTextureWithAnimation().size(1.25f, 5.0f, 5.0f).addExperience(2).regen(20).addToAttribute(Attributes.f_22276_, 20.0).addToAttribute(Attributes.f_22281_, 2.0).multiplyAttribute(Attributes.f_22279_, 0.6);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new QueenGhastSpeciesConfig(manager, species, 3, 6, 4, 10);
    }

    public QueenGhastSpeciesConfig getConfig() {
        return (QueenGhastSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Queen Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        QueenGhastEntity.addBaseLoot(loot);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42417_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42564_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<QueenGhastEntity> getVariantFactory() {
        return QueenGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends QueenGhastEntity> getSpecies() {
        return SPECIES;
    }

    public QueenGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, Level level) {
        super(entityType, level);
        this.babies = this.getConfig().QUEEN.babies.next(this.f_19796_);
        this.summons = this.getConfig().QUEEN.summons.next(this.f_19796_);
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        if (!this.m_9236_().m_5776_() && this.summons > 0 && this.f_19796_.m_188503_(2) == 0) {
            --this.summons;
            double vX = target.m_20185_() - this.m_20185_();
            double vZ = target.m_20189_() - this.m_20189_();
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            this.spawnBaby(vX / vH + this.m_20184_().f_82479_ * 0.2, vZ / vH + this.m_20184_().f_82481_ * 0.2, null);
            this.m_21373_();
            References.LevelEvent.GHAST_SHOOT.play((Entity)this);
        } else {
            super.m_6504_(target, damageMulti);
        }
    }

    @Override
    protected int getVariantExplosionPower(int radius) {
        return Math.round((float)radius * 1.5f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_21224_() && !this.m_213877_() && this.m_9236_() instanceof ServerLevelAccessor) {
            SpawnGroupData groupData = null;
            for (int i = 0; i < this.babies; ++i) {
                groupData = this.spawnBaby((this.f_19796_.m_188500_() - 0.5) * 0.3, (this.f_19796_.m_188500_() - 0.5) * 0.3, groupData);
            }
            this.m_21373_();
            References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        }
        super.m_142687_(reason);
    }

    @Nullable
    private SpawnGroupData spawnBaby(double vX, double vZ, @Nullable SpawnGroupData groupData) {
        BabyGhastEntity baby = (BabyGhastEntity)((EntityType)BabyGhastEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
        if (baby == null) {
            return groupData;
        }
        baby.m_20359_((Entity)this);
        baby.f_20885_ = this.m_146908_();
        baby.f_20883_ = this.m_146908_();
        groupData = ForgeEventFactory.onFinalizeSpawn((Mob)baby, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)groupData, null);
        baby.m_6710_(this.m_5448_());
        baby.m_20334_(vX, 0.0, vZ);
        baby.m_6853_(false);
        this.m_9236_().m_7967_((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Babies", (byte)this.babies);
        saveTag.m_128344_("Summons", (byte)this.summons);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Babies", 99)) {
            this.babies = saveTag.m_128445_("Babies");
        }
        if (saveTag.m_128425_("Summons", 99)) {
            this.summons = saveTag.m_128445_("Summons");
        }
    }
}

