/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class FighterGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FighterGhastEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(8000256).uniqueTextureWithAnimation().size(0.5f, 2.0f, 2.0f).addExperience(1).disableRangedAttack().addToAttribute(Attributes.f_22276_, 20.0).addToAttribute(Attributes.f_22284_, 10.0).addToAttribute(Attributes.f_22281_, 2.0).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Fighter Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FighterGhastEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42416_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FighterGhastEntity> getVariantFactory() {
        return FighterGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FighterGhastEntity> getSpecies() {
        return SPECIES;
    }

    public FighterGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.causeLifeLoss(target, 2.0f);
        MobHelper.knockback((Entity)this, target, 2.0f, 0.5f);
    }
}

