/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

@SpecialMob
public class ThiefEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ThiefEndermanEntity> SPECIES;
    private int teleportTargetDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(326144).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().addExperience(2).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Thief Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ThiefEndermanEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (ItemLike)Items.f_42584_, 1);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<ThiefEndermanEntity> getVariantFactory() {
        return ThiefEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ThiefEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public ThiefEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (!this.m_9236_().m_5776_() && target.m_6084_() && this.teleportTargetDelay <= 0) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportTarget(target)) continue;
                this.teleportTargetDelay = 160;
                for (int j = 0; j < 16 && !this.m_32500_((Entity)target); ++j) {
                }
                break;
            }
        }
    }

    private boolean teleportTarget(LivingEntity target) {
        EntityTeleportEvent.ChorusFruit event;
        double xI = target.m_20185_();
        double yI = target.m_20186_();
        double zI = target.m_20189_();
        double x = xI + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double y = yI + (double)this.f_19796_.m_188503_(64) - 32.0;
        double z = zI + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        if (target.m_20159_()) {
            target.m_8127_();
        }
        if ((event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)target, (double)x, (double)y, (double)z)).isCanceled()) {
            return false;
        }
        if (target.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) {
            this.m_9236_().m_6263_(null, xI, yI, zI, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            target.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            --this.teleportTargetDelay;
        }
    }
}

