/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class LightningEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<LightningEndermanEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x4BB4B5).theme(BestiaryInfo.Theme.STORM).uniqueTextureWithEyes().addExperience(2).fireImmune().waterInsensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lightning Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        LightningEndermanEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42451_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<LightningEndermanEntity> getVariantFactory() {
        return LightningEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends LightningEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public LightningEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        ExplosionHelper.spawnLightning(this.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_());
        for (int i = 0; i < 64 && !this.m_32529_(); ++i) {
        }
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
    }
}

