/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DrownedSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

@SpecialMob
public class TropicalDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<TropicalDrownedEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14246563).weight(BestiaryInfo.DefaultWeight.LOWEST).theme(BestiaryInfo.Theme.TROPICAL).uniqueTextureWithOverlay().addExperience(1).multiplyRangedCooldown(0.75f).rangedMaxRange(15.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new DrownedSpeciesConfig(manager, species, 1.0, 0.0625);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Tropical Drowned", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        TropicalDrownedEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Blocks.f_50567_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50594_, Blocks.f_50552_, Blocks.f_50584_, Blocks.f_50595_, Blocks.f_50553_, Blocks.f_50585_, Blocks.f_50596_, Blocks.f_50554_, Blocks.f_50586_, Blocks.f_50597_, Blocks.f_50555_, Blocks.f_50587_, Blocks.f_50598_, Blocks.f_50556_, Blocks.f_50588_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<TropicalDrownedEntity> getVariantFactory() {
        return TropicalDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends TropicalDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public TropicalDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19614_);
    }

    @Override
    protected ItemStack getTridentForRanged() {
        return MobHelper.tridentWithEffect(MobEffects.f_19614_, 1, MobHelper.defaultEffectDuration(this.m_9236_().m_46791_()));
    }
}

