/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.crust.api.lib.CrustObjects;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousGoToWaterGoal;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class AbyssalDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<AbyssalDrownedEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(2242628).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTexturesAll().addExperience(2).effectImmune("crust:weight", MobEffects.f_19620_).addToAttribute(Attributes.f_22276_, 20.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Abyssal Drowned", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        AbyssalDrownedEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42587_, Items.f_42695_, Items.f_42696_});
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42417_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<AbyssalDrownedEntity> getVariantFactory() {
        return AbyssalDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends AbyssalDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public AbyssalDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.f_21345_, 1);
        this.f_21345_.m_25352_(1, (Goal)new AmphibiousGoToWaterGoal((Mob)this, 1.0).alwaysEnabled());
        AIHelper.removeGoals(this.f_21345_, 5);
        AIHelper.removeGoals(this.f_21345_, 6);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, CrustObjects.weight(), 2);
    }
}

