/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.CreeperFamilyConfig;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.IExplodingMob;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialCreeperEntity
extends Creeper
implements IExplodingMob,
ISpecialMob<_SpecialCreeperEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialCreeperEntity> SPECIES;
    private static final EntityDataAccessor<Float> SCALE;
    private static final EntityDataAccessor<Byte> EXPLODE_FLAGS;
    private static final byte EXPLODE_FLAG_SUPERCHARGED = 1;
    private static final byte EXPLODE_FLAG_DEFUSE_IN_WATER = 2;
    private static final byte EXPLODE_FLAG_ON_FIRE = 4;
    private static final byte EXPLODE_FLAG_WHEN_SHOT = 8;
    private SpecialMobData<_SpecialCreeperEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).modBaseTexture("textures/entity/creeper/base_creeper.png").experience(5);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(manager, species, false, false, false);
    }

    public CreeperSpeciesConfig getConfig() {
        return (CreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_32318_() {
        return Creeper.m_32318_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialCreeperEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Creeper", "Creeper", "Creeper", "Creeper", "Creeper", "Creeper", "Creeper");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20558_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return Collections.singletonList(SMTags.EntityTypes.CREEPERS);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialCreeperEntity> getFactory() {
        return _SpecialCreeperEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    protected void m_32315_() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.makeVariantExplosion(this.getVariantExplosionPower(this.f_32272_));
            this.m_146870_();
            this.m_32316_();
        }
    }

    protected float getVariantExplosionPower(float radius) {
        return radius * (this.isSupercharged() ? 3.5f : (this.m_7090_() ? 2.0f : 1.0f));
    }

    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, true, false);
    }

    protected void m_32316_() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(this.m_21220_());
        this.modifyVariantLingeringCloudEffects(effects);
        if (!effects.isEmpty()) {
            AreaEffectCloud potionCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            potionCloud.m_19712_(this.getVariantExplosionPower((float)this.f_32272_ - 0.5f));
            potionCloud.m_19732_(-0.5f);
            potionCloud.m_19740_(10);
            potionCloud.m_19734_(potionCloud.m_19748_() / 2);
            potionCloud.m_19738_(-potionCloud.m_19743_() / (float)potionCloud.m_19748_());
            for (MobEffectInstance effect : effects) {
                potionCloud.m_19716_(new MobEffectInstance(effect));
            }
            this.modifyVariantLingeringCloud(potionCloud);
            this.m_9236_().m_7967_((Entity)potionCloud);
        }
    }

    protected void modifyVariantLingeringCloudEffects(List<MobEffectInstance> potions) {
    }

    protected void modifyVariantLingeringCloud(AreaEffectCloud potionCloud) {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
        this.setCannotExplodeWhileWet(!this.getConfig().CREEPERS.canExplodeWhileWet.get());
        this.setExplodesWhileBurning(this.getConfig().CREEPERS.explodesWhileBurning.get());
        this.setExplodesWhenShot(this.getConfig().CREEPERS.explodesWhenShot.get());
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialCreeperEntity>(this, SCALE);
        this.f_19804_.m_135372_(EXPLODE_FLAGS, (Object)0);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            if (this.m_20071_() && this.cannotExplodeWhileWet()) {
                if (this.m_32311_()) {
                    this.f_19804_.m_135381_(f_32275_, (Object)false);
                }
                this.m_32283_(-1);
            } else if (this.m_6060_() && this.explodesWhileBurning()) {
                this.m_32283_(1);
            }
        }
        super.m_8119_();
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
        this.charge();
        super.m_8038_(level, lightningBolt);
        if (this.explodesWhileBurning()) {
            this.m_20095_();
        }
    }

    public void charge() {
        if (!this.m_7090_()) {
            this.setPowered(true);
            if (((CreeperFamilyConfig)((Object)MobFamily.CREEPER.config)).CREEPERS.superchargeChance.rollChance(this.f_19796_)) {
                this.setSupercharged(true);
            }
        }
    }

    public void copyChargedState(_SpecialCreeperEntity other) {
        this.setPowered(other.m_7090_());
        this.setSupercharged(other.isSupercharged());
    }

    private void setPowered(boolean charged) {
        this.f_19804_.m_135381_(f_32274_, (Object)charged);
    }

    public boolean isSupercharged() {
        return this.getExplodeFlag((byte)1);
    }

    private void setSupercharged(boolean value) {
        if (value && !this.m_7090_()) {
            this.setPowered(true);
        }
        this.setExplodeFlag((byte)1, value);
    }

    public boolean cannotExplodeWhileWet() {
        return this.getExplodeFlag((byte)2);
    }

    private void setCannotExplodeWhileWet(boolean value) {
        this.setExplodeFlag((byte)2, value);
        this.m_21441_(BlockPathTypes.WATER, value ? BlockPathTypes.LAVA.m_77124_() : BlockPathTypes.WATER.m_77124_());
    }

    public boolean explodesWhileBurning() {
        return this.getExplodeFlag((byte)4);
    }

    private void setExplodesWhileBurning(boolean value) {
        this.setExplodeFlag((byte)4, value);
        if (value) {
            this.m_21441_(BlockPathTypes.DANGER_FIRE, BlockPathTypes.DAMAGE_FIRE.m_77124_());
            this.m_21441_(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.BLOCKED.m_77124_());
        } else {
            this.m_21441_(BlockPathTypes.DANGER_FIRE, BlockPathTypes.DANGER_FIRE.m_77124_());
            this.m_21441_(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DAMAGE_FIRE.m_77124_());
        }
    }

    public boolean explodesWhenShot() {
        return this.getExplodeFlag((byte)8);
    }

    private void setExplodesWhenShot(boolean value) {
        this.setExplodeFlag((byte)8, value);
    }

    private boolean getExplodeFlag(byte flag) {
        return ((Byte)this.f_19804_.m_135370_(EXPLODE_FLAGS) & flag) != 0;
    }

    private void setExplodeFlag(byte flag, boolean value) {
        byte allFlags = (Byte)this.f_19804_.m_135370_(EXPLODE_FLAGS);
        if (value == ((allFlags & flag) == 0)) {
            this.f_19804_.m_135381_(EXPLODE_FLAGS, (Object)((byte)(allFlags ^ flag)));
        }
    }

    @Override
    public SpecialMobData<_SpecialCreeperEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialCreeperEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes type, float malus) {
        this.m_21441_(type, malus);
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (level.m_6106_().m_6534_()) {
            double chargedChance;
            double d = chargedChance = this.getConfig().CREEPERS.stormChargeChance.get() < 0.0 ? ((CreeperFamilyConfig)((Object)MobFamily.CREEPER.config)).CREEPERS.familyStormChargeChance.get() : this.getConfig().CREEPERS.stormChargeChance.get();
            if (this.f_19796_.m_188500_() < chargedChance) {
                this.charge();
            }
        }
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6126_() && source.m_7640_() instanceof Snowball) {
            amount = Math.max(3.0f, amount);
        }
        if (super.m_6469_(source, amount)) {
            if (source.m_7640_() != source.m_7639_() && this.explodesWhenShot()) {
                this.m_32312_();
            }
            return true;
        }
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.m_128379_("Supercharged", this.isSupercharged());
        saveTag.m_128379_("CannotExplodeWhileWet", this.cannotExplodeWhileWet());
        saveTag.m_128379_("ExplodesWhileBurning", this.explodesWhileBurning());
        saveTag.m_128379_("ExplodesWhenShot", this.explodesWhenShot());
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.m_128425_("Supercharged", 99)) {
            this.setSupercharged(saveTag.m_128471_("Supercharged"));
        }
        if (saveTag.m_128425_("CannotExplodeWhileWet", 99)) {
            this.setCannotExplodeWhileWet(saveTag.m_128471_("CannotExplodeWhileWet"));
        }
        if (saveTag.m_128425_("ExplodesWhileBurning", 99)) {
            this.setExplodesWhileBurning(saveTag.m_128471_("ExplodesWhileBurning"));
        }
        if (saveTag.m_128425_("ExplodesWhenShot", 99)) {
            this.setExplodesWhenShot(saveTag.m_128471_("ExplodesWhenShot"));
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        EXPLODE_FLAGS = SynchedEntityData.m_135353_(_SpecialCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    }
}

