/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.SplittingCreeperSpeciesConfig;
import fathertoast.specialmobs.common.entity.creeper.MiniCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class SplittingCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SplittingCreeperEntity> SPECIES;
    private int extraBabies;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(6266146).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().size(1.2f, 0.7f, 1.99f).addExperience(2).addToAttribute(Attributes.f_22276_, 20.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SplittingCreeperSpeciesConfig(manager, species, false, false, true, 1, 3);
    }

    @Override
    public SplittingCreeperSpeciesConfig getConfig() {
        return (SplittingCreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Splitting Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SplittingCreeperEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42555_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SplittingCreeperEntity> getVariantFactory() {
        return SplittingCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SplittingCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SplittingCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
        this.extraBabies = this.getConfig().SPLITTING.extraBabies.next(this.f_19796_);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, false, false);
        if (!(this.m_9236_() instanceof ServerLevelAccessor)) {
            return;
        }
        int babiesToSpawn = this.extraBabies + (int)(explosionPower * explosionPower) / 2;
        SpawnGroupData groupData = null;
        for (int i = 0; i < babiesToSpawn; ++i) {
            groupData = this.spawnBaby(explosionPower / 3.0f, groupData);
        }
        this.m_21373_();
        this.m_5496_(SoundEvents.f_11877_, 1.0f, 2.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    @Nullable
    private SpawnGroupData spawnBaby(float speed, @Nullable SpawnGroupData groupData) {
        MiniCreeperEntity baby = (MiniCreeperEntity)((EntityType)MiniCreeperEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
        if (baby == null) {
            return groupData;
        }
        baby.m_20359_((Entity)this);
        baby.f_20885_ = this.m_146908_();
        baby.f_20883_ = this.m_146908_();
        groupData = ForgeEventFactory.onFinalizeSpawn((Mob)baby, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)groupData, null);
        baby.copyChargedState(this);
        baby.m_6710_(this.m_5448_());
        baby.m_20334_((this.f_19796_.m_188500_() - 0.5) * (double)speed, 0.3 + 0.3 * this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * (double)speed);
        baby.m_6853_(false);
        this.m_9236_().m_7967_((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("ExtraBabies", (byte)this.extraBabies);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("ExtraBabies", 99)) {
            this.extraBabies = saveTag.m_128445_("ExtraBabies");
        }
    }
}

