/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.config.species.SnowCreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.entity.skeleton.StraySkeletonEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class SnowCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SnowCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE8F8F8).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).uniqueTextureWithEyes().addExperience(2).effectImmune(MobEffects.f_19597_).addToAttribute(Attributes.f_22276_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SnowCreeperSpeciesConfig(manager, species, false, false, false, 0.33);
    }

    @Override
    public SnowCreeperSpeciesConfig getConfig() {
        return (SnowCreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Snow Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SnowCreeperEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Items.f_42452_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50354_});
        loot.addRareDrop("rare", new ItemLike[]{Blocks.f_50568_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SnowCreeperEntity> getVariantFactory() {
        return SnowCreeperEntity::new;
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.CREEPERS, EntityTypeTags.f_144294_);
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SnowCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SnowCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((PathfinderMob)this, 0.8);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FluidPathNavigator((Mob)this, level, true, false);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13131_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        MobHelper.floatInFluid((Entity)this, 0.08, (FluidType)ForgeMod.WATER_TYPE.get());
        MobHelper.hopOnFluid((Entity)this);
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        MobHelper.updateFrostWalker((LivingEntity)this, pos);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius) + 3.0f;
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.BlockInteraction explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionMode == Explosion.BlockInteraction.KEEP ? explosionPower : 2.0f, false, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        int radius = (int)Math.floor(explosionPower);
        BlockPos center = BlockPos.m_274446_((Position)explosion.getPos());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (explosionMode != Explosion.BlockInteraction.KEEP) {
            boolean snowGlobe = this.m_5842_() || this.f_19796_.m_188500_() < this.getConfig().SNOW.snowGlobeChance.get();
            int radiusSq = radius * radius;
            int rMinusOneSq = (radius - 1) * (radius - 1);
            for (int y = -radius; y <= radius; ++y) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockState blockAbove;
                        int distSq = x * x + y * y + z * z;
                        if (distSq > radiusSq) continue;
                        pos.m_122154_((Vec3i)center, x, y, z);
                        BlockState block = this.m_9236_().m_8055_((BlockPos)pos);
                        if ((block.m_60713_(Blocks.f_50449_) || block.m_60734_() == Blocks.f_49990_ && (Integer)block.m_61143_((Property)LiquidBlock.f_54688_) == 0) && !(blockAbove = this.m_9236_().m_8055_(pos.m_7494_())).m_280555_() && !blockAbove.m_60819_().m_205070_(FluidTags.f_13131_) && MobHelper.placeBlock((Entity)this, (BlockPos)pos, MeltingIceBlock.getState(this.m_9236_(), (BlockPos)pos))) {
                            MeltingIceBlock.scheduleFirstTick(this.m_9236_(), (BlockPos)pos, this.f_19796_);
                        }
                        if (distSq <= rMinusOneSq) continue;
                        if (snowGlobe) {
                            if (!this.m_9236_().m_8055_((BlockPos)pos).m_247087_() || !MobHelper.placeBlock((Entity)this, (BlockPos)pos, MeltingIceBlock.getState(this.m_9236_(), (BlockPos)pos))) continue;
                            MeltingIceBlock.scheduleFirstTick(this.m_9236_(), (BlockPos)pos, this.f_19796_);
                            continue;
                        }
                        if (y != 0) continue;
                        this.placePillar((BlockPos)pos, radius);
                    }
                }
            }
        }
        int strays = radius / 2;
        for (int count = 0; count < strays; ++count) {
            for (int attempt = 0; attempt < 8 && !this.trySpawnStray(center, radius); ++attempt) {
            }
        }
    }

    private void placePillar(BlockPos pos, int radius) {
        BlockPos.MutableBlockPos currentPos = pos.m_122032_();
        if (this.shouldReplace((BlockPos)currentPos)) {
            this.findGroundBelow(currentPos, radius);
        } else if (this.findGroundAbove(currentPos, radius)) {
            return;
        }
        int maxY = Math.min(currentPos.m_123342_() + 4, this.m_9236_().m_151558_() - 2);
        int height = -2;
        if (pos.m_123342_() > currentPos.m_123342_()) {
            height -= (pos.m_123342_() - currentPos.m_123342_()) / 2;
        }
        while (currentPos.m_123342_() < maxY && this.shouldReplace((BlockPos)currentPos)) {
            if (MobHelper.placeBlock((Entity)this, (BlockPos)currentPos, MeltingIceBlock.getState(this.m_9236_(), (BlockPos)currentPos))) {
                MeltingIceBlock.scheduleFirstTick(this.m_9236_(), (BlockPos)currentPos, this.f_19796_);
            }
            currentPos.m_122184_(0, 1, 0);
            if (++height < 0 || !this.f_19796_.m_188499_()) continue;
            break;
        }
    }

    private void findGroundBelow(BlockPos.MutableBlockPos currentPos, int radius) {
        int yI = currentPos.m_123342_();
        int minY = Math.max(yI - radius, 0);
        while (currentPos.m_123342_() > minY) {
            currentPos.m_122184_(0, -1, 0);
            if (this.shouldReplace((BlockPos)currentPos)) continue;
            currentPos.m_122184_(0, 1, 0);
            return;
        }
        currentPos.m_142448_(yI);
    }

    private boolean findGroundAbove(BlockPos.MutableBlockPos currentPos, int radius) {
        int yI = currentPos.m_123342_();
        int maxY = Math.min(yI + radius, this.m_9236_().m_151558_() - 2);
        while (currentPos.m_123342_() < maxY) {
            currentPos.m_122184_(0, 1, 0);
            if (!this.shouldReplace((BlockPos)currentPos)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldReplace(BlockPos pos) {
        BlockState stateAtPos = this.m_9236_().m_8055_(pos);
        return (stateAtPos.m_247087_() || stateAtPos.m_204336_(BlockTags.f_13035_)) && !stateAtPos.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private boolean trySpawnStray(BlockPos center, int radius) {
        if (!(this.m_9236_() instanceof ServerLevelAccessor)) {
            return false;
        }
        StraySkeletonEntity stray = (StraySkeletonEntity)((EntityType)StraySkeletonEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
        if (stray == null) {
            return false;
        }
        float angle = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
        float distance = this.f_19796_.m_188501_() * (float)(radius - 1);
        BlockPos.MutableBlockPos currentPos = center.m_122032_().m_122184_(Mth.m_14143_((float)(Mth.m_14089_((float)angle) * distance)), 0, Mth.m_14143_((float)(Mth.m_14031_((float)angle) * distance)));
        if (this.shouldReplace((BlockPos)currentPos)) {
            this.findGroundBelow(currentPos, radius);
        } else if (this.findGroundAbove(currentPos, radius)) {
            stray.m_146870_();
            return false;
        }
        stray.m_20035_((BlockPos)currentPos, angle * 180.0f / (float)Math.PI + 180.0f, 0.0f);
        while (!this.m_9236_().m_45772_(stray.m_20191_())) {
            if (currentPos.m_123342_() > center.m_123342_() + radius) {
                stray.m_146870_();
                return false;
            }
            currentPos.m_122184_(0, 1, 0);
            stray.m_20035_((BlockPos)currentPos, stray.m_146908_(), stray.m_146909_());
        }
        stray.m_6710_(this.m_5448_());
        ForgeEventFactory.onFinalizeSpawn((Mob)stray, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
        this.m_9236_().m_7967_((Entity)stray);
        stray.m_21373_();
        return true;
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }
}

