/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.entity.projectile.BoneShrapnelEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class SkeletonCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SkeletonCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xC1C1C1).theme(BestiaryInfo.Theme.FOREST).uniqueTextureBaseOnly().addExperience(1).undead().addToAttribute(Attributes.f_22276_, -4.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Skeleton Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SkeletonCreeperEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.f_20524_.m_20677_());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SkeletonCreeperEntity> getVariantFactory() {
        return SkeletonCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SkeletonCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SkeletonCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.f_21345_, 3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        AIHelper.insertGoal(this.f_21345_, 3, (Goal)new RestrictSunGoal((PathfinderMob)this));
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, true, false);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        float shootPower = explosionPower * 2.0f + 4.0f;
        int count = (int)Math.ceil(shootPower * shootPower * 3.5f);
        for (int i = 0; i < count; ++i) {
            BoneShrapnelEntity shrapnel = this.makeShrapnel(shootPower);
            float speed = (0.7f + this.f_19796_.m_188501_()) * shootPower / 20.0f;
            float pitch = this.f_19796_.m_188501_() * (float)Math.PI;
            float yaw = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
            Vec3 velocity = new Vec3((double)(Mth.m_14089_((float)yaw) * speed), (double)(Mth.m_14031_((float)pitch) * (shootPower + this.f_19796_.m_188501_() * shootPower) / 18.0f), (double)(Mth.m_14031_((float)yaw) * speed));
            shrapnel.m_6686_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, (float)velocity.m_82553_(), 0.0f);
            shrapnel.life = (int)((float)shrapnel.life + pitch * 6.0f);
            this.m_9236_().m_7967_((Entity)shrapnel);
        }
        this.m_21373_();
        this.m_5496_(SoundEvents.f_12424_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    private BoneShrapnelEntity makeShrapnel(float damage) {
        BoneShrapnelEntity shrapnel = new BoneShrapnelEntity((LivingEntity)this);
        shrapnel.m_36745_((LivingEntity)this, damage);
        if (this.m_6060_()) {
            shrapnel.m_20254_(100);
        }
        byte pierce = 1;
        if (this.m_7090_()) {
            shrapnel.m_36762_(true);
            pierce = (byte)(pierce + 1);
        }
        if (this.isSupercharged()) {
            shrapnel.m_36735_(shrapnel.m_150123_() + 2);
            pierce = (byte)(pierce + 1);
        }
        shrapnel.m_36767_(pierce);
        return shrapnel;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public void m_8107_() {
        if (this.m_21527_()) {
            ItemStack hat = this.m_6844_(EquipmentSlot.HEAD);
            if (!hat.m_41619_()) {
                if (hat.m_41763_()) {
                    hat.m_41721_(hat.m_41773_() + this.f_19796_.m_188503_(2));
                    if (hat.m_41773_() >= hat.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
            } else {
                this.m_20254_(8);
            }
        }
        super.m_8107_();
    }
}

