/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

@SpecialMob
public class SandCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SandCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15130028).theme(BestiaryInfo.Theme.DESERT).uniqueTextureBaseOnly().addExperience(1).addToAttribute(Attributes.f_22284_, 2.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Sand Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SandCreeperEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Blocks.f_49992_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50063_});
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42417_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SandCreeperEntity> getVariantFactory() {
        return SandCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SandCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public SandCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        LevelData levelData;
        ExplosionHelper explosion;
        Explosion.BlockInteraction explosionMode = ExplosionHelper.getMode((Entity)this);
        if (explosionMode != Explosion.BlockInteraction.KEEP) {
            int radius = (int)Math.floor(explosionPower) + 2;
            BlockPos center = BlockPos.m_274446_((Position)this.m_20182_());
            for (int y = -radius; y <= radius; ++y) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + y * y + z * z > radius * radius) continue;
                        this.clearWater(center.m_7918_(x, y, z));
                    }
                }
            }
        }
        if (!(explosion = new ExplosionHelper((Entity)this, explosionPower, explosionMode, false)).initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (this.m_7090_() && (levelData = this.m_9236_().m_6106_()) instanceof ServerLevelData) {
            ServerLevelData serverData = (ServerLevelData)levelData;
            serverData.m_6393_(this.f_19796_.m_188503_(12000) + 3600);
            serverData.m_6399_(0);
            serverData.m_5565_(false);
            serverData.m_6398_(0);
            serverData.m_5557_(false);
        }
    }

    private void clearWater(BlockPos pos) {
        BucketPickup bucketPickup;
        if (!this.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return;
        }
        BlockState block = this.m_9236_().m_8055_(pos);
        Block block2 = block.m_60734_();
        if (block2 instanceof BucketPickup && (bucketPickup = (BucketPickup)block2).m_142598_((LevelAccessor)this.m_9236_(), pos, block) != ItemStack.f_41583_) {
            return;
        }
        if (block.m_60734_() instanceof LiquidBlock) {
            this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return;
        }
        if (block.m_204336_(BlockTags.f_278394_)) {
            BlockEntity blockEntity = block.m_155947_() ? this.m_9236_().getExistingBlockEntity(pos) : null;
            Block.m_49892_((BlockState)block, (LevelAccessor)this.m_9236_(), (BlockPos)pos, (BlockEntity)blockEntity);
            this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @Override
    protected void modifyVariantLingeringCloudEffects(List<MobEffectInstance> potions) {
        potions.add(new MobEffectInstance(MobEffects.f_19612_, 600));
    }

    @Override
    protected void modifyVariantLingeringCloud(AreaEffectCloud potionCloud) {
        int duration = 40;
        float minRadius = 0.5f;
        float maxRadius = (this.getVariantExplosionPower(this.f_32272_) + 1.0f) * 3.0f;
        potionCloud.m_19734_(40);
        potionCloud.m_19712_(0.5f);
        potionCloud.m_19738_((maxRadius - 0.5f) / 40.0f);
        potionCloud.m_19732_(0.0f);
    }
}

