/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

@SpecialMob
public class LightningCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<LightningCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(4824238).theme(BestiaryInfo.Theme.STORM).uniqueTextureBaseOnly().addExperience(1).fireImmune();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lightning Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        LightningCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42451_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<LightningCreeperEntity> getVariantFactory() {
        return LightningCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends LightningCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public LightningCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return this.isSupercharged() || this.m_7090_() ? super.getVariantExplosionPower(radius) : radius / 3.0f;
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        LevelData x2;
        super.makeVariantExplosion(explosionPower);
        if (!this.m_9236_().m_5776_()) {
            ExplosionHelper.spawnLightning(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (explosionPower >= 2.0f) {
                int radius = (int)Math.floor(explosionPower);
                for (int x2 = -radius; x2 <= radius; ++x2) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x2 == 0 && z == 0 || x2 * x2 + z * z > radius * radius || !(this.f_19796_.m_188501_() < 0.3f)) continue;
                        ExplosionHelper.spawnLightning(this.m_9236_(), this.m_20185_() + (double)x2, this.m_20186_(), this.m_20189_() + (double)z);
                    }
                }
            }
        }
        if (this.m_7090_() && (x2 = this.m_9236_().m_6106_()) instanceof ServerLevelData) {
            ServerLevelData serverData = (ServerLevelData)x2;
            int duration = this.f_19796_.m_188503_(12000) + 3600;
            if (!serverData.m_6534_() || serverData.m_6558_() < duration) {
                serverData.m_6398_(duration);
                serverData.m_5557_(true);
            }
            if (!serverData.m_6533_() || serverData.m_6531_() < (duration += 1200)) {
                serverData.m_6399_(duration);
                serverData.m_5565_(true);
            }
        }
    }
}

