/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

@SpecialMob
public class GravelCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<GravelCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(9472132).uniqueTextureBaseOnly().addExperience(1).burnImmune();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Gravel Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        GravelCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Blocks.f_49994_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42484_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<GravelCreeperEntity> getVariantFactory() {
        return GravelCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends GravelCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public GravelCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.BlockInteraction explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionPower, explosionMode, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (explosionMode == Explosion.BlockInteraction.KEEP || this.m_9236_().m_5776_()) {
            return;
        }
        float throwPower = explosionPower + 4.0f;
        int count = (int)Math.ceil(throwPower * throwPower * 3.5f);
        for (int i = 0; i < count; ++i) {
            BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_());
            FallingBlockEntity gravel = new FallingBlockEntity(this.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, Blocks.f_49994_.m_49966_());
            gravel.f_31942_ = 1;
            gravel.f_31943_ = false;
            gravel.f_19789_ = 3.0f;
            float speed = (throwPower * 0.7f + this.f_19796_.m_188501_() * throwPower) / 20.0f;
            float pitch = this.f_19796_.m_188501_() * (float)Math.PI;
            float yaw = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
            gravel.m_20334_((double)(Mth.m_14089_((float)yaw) * speed), (double)(Mth.m_14031_((float)pitch) * (throwPower + this.f_19796_.m_188501_() * throwPower) / 18.0f), (double)(Mth.m_14031_((float)yaw) * speed));
            this.m_9236_().m_7967_((Entity)gravel);
        }
        this.m_21373_();
        this.m_5496_(SoundEvents.f_11993_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268526_)) {
            return true;
        }
        return super.m_6469_(source, amount);
    }
}

