/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class FireCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14760214).theme(BestiaryInfo.Theme.FIRE).uniqueTextureBaseOnly().addExperience(1).fireImmune().waterSensitive();
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(manager, species, true, false, false);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Fire Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42413_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.CREEPERS, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FireCreeperEntity> getVariantFactory() {
        return FireCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public FireCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, true, true);
    }
}

