/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

@SpecialMob
public class EnderCreeperEntity
extends _SpecialCreeperEntity
implements NeutralMob {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<EnderCreeperEntity> SPECIES;
    private static final UniformInt PERSISTENT_ANGER_TIME;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private static final EntityDataAccessor<Boolean> DATA_CREEPY;
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT;
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(13369594).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().addExperience(2).waterSensitive().addToAttribute(Attributes.f_22276_, 20.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new CreeperSpeciesConfig(manager, species, true, false, false);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Endercreeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        EnderCreeperEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.f_20566_.m_20677_());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<EnderCreeperEntity> getVariantFactory() {
        return EnderCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends EnderCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public EnderCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.f_21345_, 4, new StareGoal(this));
        AIHelper.removeGoals(this.f_21346_, NearestAttackableTargetGoal.class);
        this.f_21346_.m_25352_(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((EnderCreeperEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        this.m_21678_(saveTag);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (!this.m_9236_().f_46443_) {
            this.m_147285_(this.m_9236_(), saveTag);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int ticks) {
        this.remainingPersistentAngerTime = ticks;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID id) {
        this.persistentAngerTarget = id;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    private boolean hasBeenStaredAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARED_AT);
    }

    private void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target == null) {
            this.targetChangeTime = 0;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
        } else {
            this.targetChangeTime = this.f_19797_;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
        }
        super.m_6710_(target);
    }

    private void playStareSound() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> parameter) {
        if (DATA_CREEPY.equals(parameter) && this.hasBeenStaredAt() && this.m_9236_().f_46443_) {
            this.playStareSound();
        }
        super.m_7350_(parameter);
    }

    private boolean isLookingAtMe(Player player) {
        ItemStack playerHelm = (ItemStack)player.m_150109_().f_35975_.get(3);
        try {
            if (playerHelm.isEnderMask(player, null)) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            SpecialMobs.LOG.error("Helmet '{}' does not support nullable enderman for ::isEnderMask check!", (Object)playerHelm.m_41778_());
            return false;
        }
        Vec3 playerViewVec = player.m_20252_(1.0f).m_82541_();
        Vec3 playerToThisVec = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double distance = playerToThisVec.m_82553_();
        double viewProjection = playerViewVec.m_82526_(playerToThisVec.m_82541_());
        return viewProjection > 1.0 - 0.025 / distance && player.m_142582_((Entity)this);
    }

    @Override
    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        float brightness;
        if (this.m_9236_().m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (brightness = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (brightness - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        super.m_8024_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && !(source.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleport();
        }
        return success;
    }

    protected boolean teleport() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleportTowards(Entity target) {
        Vec3 directionFromTarget = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_()).m_82541_();
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - directionFromTarget.f_82479_ * 16.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - directionFromTarget.f_82480_ * 16.0;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - directionFromTarget.f_82481_ * 16.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > 0 && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState block = this.m_9236_().m_8055_((BlockPos)pos);
        if (!block.m_280555_() || block.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
        if (event.isCanceled()) {
            return false;
        }
        boolean success = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (success && !this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return success;
    }

    static {
        PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
        DATA_CREEPY = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_STARED_AT = SynchedEntityData.m_135353_(EnderCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    static class StareGoal
    extends Goal {
        private final EnderCreeperEntity creeper;
        private LivingEntity target;

        public StareGoal(EnderCreeperEntity entity) {
            this.creeper = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.creeper.m_5448_();
            return this.target instanceof Player && this.target.m_20280_((Entity)this.creeper) <= 256.0 && this.creeper.isLookingAtMe((Player)this.target);
        }

        public void m_8056_() {
            this.creeper.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.creeper.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EnderCreeperEntity creeper;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;

        public FindPlayerGoal(EnderCreeperEntity entity, @Nullable Predicate<LivingEntity> targetSelector) {
            super((Mob)entity, Player.class, 10, false, false, targetSelector);
            this.creeper = entity;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(target -> entity.isLookingAtMe((Player)target));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.creeper.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.creeper);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.creeper.setBeingStaredAt();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.creeper.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.creeper.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.creeper, this.f_26050_) || super.m_8045_();
        }

        public void m_8037_() {
            if (this.creeper.m_5448_() == null) {
                super.m_26070_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.creeper.m_20159_()) {
                    if (this.creeper.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.creeper) < 16.0) {
                            this.creeper.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.creeper) > 256.0 && this.teleportTime++ >= 30 && this.creeper.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

