/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@SpecialMob
public class DirtCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DirtCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7886139).uniqueTextureBaseOnly().addExperience(1).burnImmune().addToAttribute(Attributes.f_22284_, 6.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Dirt Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DirtCreeperEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Blocks.f_50493_);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42406_);
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42619_, Items.f_42620_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DirtCreeperEntity> getVariantFactory() {
        return DirtCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DirtCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DirtCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.BlockInteraction explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionPower, false, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (explosionMode == Explosion.BlockInteraction.KEEP) {
            return;
        }
        BlockState dirt = Blocks.f_50493_.m_49966_();
        int radius = (int)Math.floor(explosionPower);
        BlockPos center = BlockPos.m_274446_((Position)explosion.getPos());
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radius * radius) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    if (!this.m_9236_().m_8055_(pos).m_247087_()) continue;
                    MobHelper.placeBlock((Entity)this, pos, dirt);
                }
            }
        }
    }
}

