/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.cavespider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.cavespider._SpecialCaveSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

@SpecialMob
public class FireCaveSpiderEntity
extends _SpecialCaveSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireCaveSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14656027).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(2).fireImmune().waterSensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Cave Firefang", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireCaveSpiderEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42413_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.CAVE_SPIDERS, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FireCaveSpiderEntity> getVariantFactory() {
        return FireCaveSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireCaveSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public FireCaveSpiderEntity(EntityType<? extends _SpecialCaveSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected int getVariantSpitColor() {
        return 14656027;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (!this.m_9236_().m_5776_()) {
            BlockPos pos = target.m_20183_();
            if (this.m_9236_().m_8055_(pos).m_247087_()) {
                MobHelper.placeBlock((Entity)this, pos, Blocks.f_50083_.m_49966_());
            }
        }
        target.m_20254_(5);
    }
}

