/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.cavespider;

import fathertoast.crust.api.lib.CrustObjects;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.cavespider._SpecialCaveSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class DesertCaveSpiderEntity
extends _SpecialCaveSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DesertCaveSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15130028).theme(BestiaryInfo.Theme.DESERT).uniqueTextureWithEyes().size(0.6f, 0.7f, 0.5f).addExperience(2).effectImmune(MobEffects.f_19597_, "crust:vulnerability").addToAttribute(Attributes.f_22276_, 4.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Desert Cave Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DesertCaveSpiderEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42454_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DesertCaveSpiderEntity> getVariantFactory() {
        return DesertCaveSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DesertCaveSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public DesertCaveSpiderEntity(EntityType<? extends _SpecialCaveSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected int getVariantSpitColor() {
        return MobEffects.f_19610_.m_19484_();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (Config.MAIN.GENERAL.enableNausea.get()) {
            MobHelper.applyEffect(target, MobEffects.f_19604_);
        }
        MobHelper.applyEffect(target, MobEffects.f_19610_);
        MobHelper.removeNightVision(target);
        MobHelper.applyEffect(target, MobEffects.f_19597_, 2);
        MobHelper.applyEffect(target, CrustObjects.vulnerability());
    }
}

