/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.WildfireBlazeSpeciesConfig;
import fathertoast.specialmobs.common.entity.blaze.CinderBlazeEntity;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class WildfireBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WildfireBlazeEntity> SPECIES;
    private int babies;
    private int summons;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16051762).uniqueTextureBaseOnly().size(1.5f, 0.9f, 2.7f).addExperience(2).regen(40).fireballAttack(0.1, 30, 50, 20.0).addToAttribute(Attributes.f_22276_, 20.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new WildfireBlazeSpeciesConfig(manager, species, 1, 0, 3, 6, 4, 10);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Wildfire", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WildfireBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42413_, 1);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42549_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<WildfireBlazeEntity> getVariantFactory() {
        return WildfireBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WildfireBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public WildfireBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
        this.babies = this.getConfig().WILDFIRE.babies.next(this.f_19796_);
        this.summons = this.getConfig().WILDFIRE.summons.next(this.f_19796_);
    }

    @Override
    public WildfireBlazeSpeciesConfig getConfig() {
        return (WildfireBlazeSpeciesConfig)this.getSpecies().config;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.m_20254_(8);
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        if (!this.m_9236_().m_5776_() && this.summons > 0 && this.f_19796_.m_188503_(2) == 0) {
            --this.summons;
            double vX = target.m_20185_() - this.m_20185_();
            double vZ = target.m_20189_() - this.m_20189_();
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            this.spawnBaby(vX / vH * 0.8 + this.m_20184_().f_82479_ * 0.2, vZ / vH * 0.8 + this.m_20184_().f_82481_ * 0.2, null);
            this.m_21373_();
            References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        } else {
            super.m_6504_(target, damageMulti);
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (this.m_21224_() && !this.m_213877_() && this.m_9236_() instanceof ServerLevelAccessor) {
            SpawnGroupData groupData = null;
            for (int i = 0; i < this.babies; ++i) {
                groupData = this.spawnBaby((this.f_19796_.m_188500_() - 0.5) * 0.3, (this.f_19796_.m_188500_() - 0.5) * 0.3, groupData);
            }
            this.m_21373_();
            References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        }
        super.m_142687_(removalReason);
    }

    @Nullable
    private SpawnGroupData spawnBaby(double vX, double vZ, @Nullable SpawnGroupData groupData) {
        CinderBlazeEntity baby = (CinderBlazeEntity)((EntityType)CinderBlazeEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
        if (baby == null) {
            return groupData;
        }
        baby.m_20359_((Entity)this);
        baby.f_20885_ = this.m_146908_();
        baby.f_20883_ = this.m_146908_();
        groupData = ForgeEventFactory.onFinalizeSpawn((Mob)baby, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)groupData, null);
        baby.m_6710_(this.m_5448_());
        baby.m_20334_(vX, 0.0, vZ);
        baby.m_6853_(false);
        this.m_9236_().m_7967_((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Babies", (byte)this.babies);
        saveTag.m_128344_("Summons", (byte)this.summons);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Babies", 99)) {
            this.babies = saveTag.m_128445_("Babies");
        }
        if (saveTag.m_128425_("Summons", 99)) {
            this.summons = saveTag.m_128445_("Summons");
        }
    }
}

