/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class SpecialLeapAtTargetGoal
extends Goal {
    private static final float BASE_Y_VELOCITY = 0.4f;
    private final Mob mob;
    private final int infrequency;
    private final float minDistSq;
    private final float maxDistSq;
    private final float forwardPower;
    private final float upwardPower;
    private float momentum = 0.2f;
    private boolean canUseWhileMounted = false;
    private boolean ignoreFallDamage = false;
    private LivingEntity target;

    public SpecialLeapAtTargetGoal(Mob entity, int infreq, float minDist, float maxDist, float forward, float upward) {
        this.mob = entity;
        this.infrequency = infreq;
        this.minDistSq = minDist * minDist;
        this.maxDistSq = maxDist * maxDist;
        this.forwardPower = forward;
        this.upwardPower = upward;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public SpecialLeapAtTargetGoal setMomentum(float value) {
        this.momentum = value;
        return this;
    }

    public SpecialLeapAtTargetGoal canUseWhileMounted() {
        this.canUseWhileMounted = true;
        return this;
    }

    public SpecialLeapAtTargetGoal ignoreFallDamage() {
        this.ignoreFallDamage = true;
        return this;
    }

    public boolean m_8036_() {
        if (!this.mob.m_20096_() || this.mob.m_20159_() || !this.canUseWhileMounted && this.mob.m_20160_()) {
            return false;
        }
        this.target = this.mob.m_5448_();
        if (this.target == null || this.mob.m_217043_().m_188503_(this.infrequency) != 0) {
            return false;
        }
        double distanceSq = this.mob.m_20280_((Entity)this.target);
        return distanceSq >= (double)this.minDistSq && distanceSq <= (double)this.maxDistSq;
    }

    public void m_8056_() {
        Vec3 vLeap = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_()).m_82541_().m_82490_((double)this.forwardPower).m_82549_(this.mob.m_20184_().m_82490_((double)this.momentum));
        this.mob.m_20334_(vLeap.f_82479_, (double)(0.4f * this.upwardPower), vLeap.f_82481_);
    }

    public boolean m_8045_() {
        return !this.mob.m_20096_() && !this.mob.m_20159_() && !this.mob.m_20072_() && !this.mob.m_20077_();
    }

    public void m_8037_() {
        if (this.ignoreFallDamage) {
            this.mob.f_19789_ = 0.0f;
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

