/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SpecialBlazeAttackGoal
extends Goal {
    private final _SpecialBlazeEntity blaze;
    private int attackStep;
    private int attackTime;
    private int lastSeen;

    public SpecialBlazeAttackGoal(_SpecialBlazeEntity entity) {
        this.blaze = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.blaze.m_5448_();
        return target != null && target.m_6084_() && this.blaze.m_6779_(target);
    }

    public void m_8056_() {
        this.attackStep = 0;
    }

    public void m_8041_() {
        this.blaze.m_32240_(false);
        this.lastSeen = 0;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity target = this.blaze.m_5448_();
        if (target == null) {
            return;
        }
        SpecialMobData<_SpecialBlazeEntity> data = this.blaze.getSpecialData();
        boolean canSee = this.blaze.m_21574_().m_148306_((Entity)target);
        this.lastSeen = canSee ? 0 : ++this.lastSeen;
        double distanceSqr = this.blaze.m_20280_((Entity)target);
        float rangeSq = data.getRangedAttackMaxRange() * data.getRangedAttackMaxRange();
        if (distanceSqr < this.getAttackReachSqr(target)) {
            if (canSee && this.attackTime <= 0) {
                this.attackTime = 20;
                this.blaze.m_7327_((Entity)target);
            }
            this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
        } else if (distanceSqr < (double)rangeSq && canSee) {
            if (this.attackTime <= 0) {
                ++this.attackStep;
                if (this.attackStep == 1) {
                    this.attackTime = data.getRangedAttackCooldown();
                    this.blaze.m_32240_(true);
                } else if (this.attackStep <= 1 + this.blaze.fireballBurstCount) {
                    this.attackTime = this.blaze.fireballBurstDelay;
                } else {
                    this.attackTime = data.getRangedAttackMaxCooldown() - data.getRangedAttackCooldown();
                    this.attackStep = 0;
                    this.blaze.m_32240_(false);
                }
                if (this.attackStep > 1) {
                    this.blaze.m_6504_(target, this.attackStep);
                }
            }
            this.blaze.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        } else if (this.lastSeen < 5) {
            this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
        }
        super.m_8037_();
    }

    public boolean m_183429_() {
        return true;
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return this.blaze.m_20205_() * this.blaze.m_20205_() * 4.0f + target.m_20205_() + 2.0f;
    }
}

