/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.IAmmoUser;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChargeCreeperGoal<T extends Mob>
extends Goal {
    private final BiPredicate<T, ? super Creeper> targetPredicate;
    private final T madman;
    private final double movementSpeed;
    private final double targetRange;
    private Creeper creeper;
    private int pathUpdateCooldown;
    private Vec3 pathTarget = Vec3.f_82478_;
    private boolean canUseWhileMounted = false;

    public ChargeCreeperGoal(T madman, double movementSpeed, double targetRange, BiPredicate<T, ? super Creeper> targetPredicate) {
        this.madman = madman;
        this.movementSpeed = movementSpeed;
        this.targetRange = targetRange;
        this.targetPredicate = targetPredicate;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public ChargeCreeperGoal<T> canUseWhileMounted() {
        this.canUseWhileMounted = true;
        return this;
    }

    public boolean m_8036_() {
        if (!((IAmmoUser)this.madman).hasAmmo() || this.madman.m_20159_() || !this.canUseWhileMounted && this.madman.m_20160_()) {
            return false;
        }
        this.findCreeper();
        if (this.creeper == null) {
            return false;
        }
        this.madman.m_21573_().m_5624_((Entity)this.creeper, this.movementSpeed);
        this.pathTarget = this.creeper.m_20182_();
        this.pathUpdateCooldown = 4 + this.madman.m_217043_().m_188503_(7);
        return this.madman.m_21573_().m_26570_() != null;
    }

    private void findCreeper() {
        Level level = this.madman.m_9236_();
        List nearbyCreepers = level.m_45976_(Creeper.class, this.madman.m_20191_().m_82400_(this.targetRange));
        if (!nearbyCreepers.isEmpty()) {
            for (Creeper creeper : nearbyCreepers) {
                if (!this.targetPredicate.test(this.madman, (Creeper)creeper)) continue;
                this.creeper = creeper;
                break;
            }
        }
    }

    public boolean m_8045_() {
        return !this.madman.m_20159_() && (this.canUseWhileMounted || this.madman.m_20160_()) && this.creeper != null && this.targetPredicate.test(this.madman, (Creeper)this.creeper);
    }

    public void m_8037_() {
        if (this.creeper == null) {
            return;
        }
        double distanceSq = this.madman.m_20280_((Entity)this.creeper);
        --this.pathUpdateCooldown;
        if (this.pathUpdateCooldown <= 0 && (this.creeper.m_20238_(this.pathTarget) >= 1.0 || this.madman.m_217043_().m_188501_() < 0.05f)) {
            this.pathUpdateCooldown = 4 + this.madman.m_217043_().m_188503_(7);
            if (distanceSq > 1024.0) {
                this.pathUpdateCooldown += 10;
            } else if (distanceSq > 256.0) {
                this.pathUpdateCooldown += 5;
            }
            if (!this.madman.m_21573_().m_5624_((Entity)this.creeper, this.movementSpeed)) {
                this.pathUpdateCooldown += 15;
            }
            this.pathTarget = this.creeper.m_20182_();
        }
        this.madman.m_21563_().m_24960_((Entity)this.creeper, 30.0f, 30.0f);
        if (distanceSq < 2.5) {
            if (((IAmmoUser)this.madman).hasAmmo()) {
                ((IAmmoUser)this.madman).consumeAmmo();
                MobHelper.charge(this.creeper);
                this.madman.m_9236_().m_6263_(null, this.creeper.m_20185_(), this.creeper.m_20186_(), this.creeper.m_20189_(), SoundEvents.f_11692_, SoundSource.HOSTILE, 0.9f, 1.0f);
            }
            this.creeper = null;
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

