/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class AmphibiousGoToWaterGoal
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private boolean disableAtNight = true;
    private double wantedX;
    private double wantedY;
    private double wantedZ;

    public AmphibiousGoToWaterGoal(Mob entity, double speed) {
        this.mob = entity;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public AmphibiousGoToWaterGoal alwaysEnabled() {
        this.disableAtNight = false;
        return this;
    }

    public boolean m_8036_() {
        if (this.disableAtNight && !this.mob.m_9236_().m_46461_() || this.mob.m_20069_()) {
            return false;
        }
        Vec3 targetPos = this.findWaterPos();
        if (targetPos == null) {
            return false;
        }
        this.wantedX = targetPos.f_82479_;
        this.wantedY = targetPos.f_82480_;
        this.wantedZ = targetPos.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    @Nullable
    private Vec3 findWaterPos() {
        RandomSource random = this.mob.m_217043_();
        BlockPos origin = this.mob.m_20183_();
        for (int i = 0; i < 10; ++i) {
            BlockPos target = origin.m_7918_(random.m_188503_(20) - 10, 2 - random.m_188503_(8), random.m_188503_(20) - 10);
            if (!this.mob.m_9236_().m_8055_(target).m_60713_(Blocks.f_49990_)) continue;
            return Vec3.m_82539_((Vec3i)target);
        }
        return null;
    }
}

