/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity;

import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fluids.FluidType;

public final class MobHelper {
    private static final MobEffectInstance[] PLAGUE_EFFECTS = new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19597_, 2, 0), new MobEffectInstance(MobEffects.f_19599_, 2, 1), new MobEffectInstance(MobEffects.f_19610_, 1, 0), new MobEffectInstance(MobEffects.f_19612_, 2, 0), new MobEffectInstance(MobEffects.f_19613_, 1, 0), new MobEffectInstance(MobEffects.f_19614_, 1, 0), new MobEffectInstance(MobEffects.f_19604_, 2, 0)};
    private static final MobEffectInstance[] WITCH_EFFECTS = new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19597_, 1, 1), new MobEffectInstance(MobEffects.f_19599_, 2, 1), new MobEffectInstance(MobEffects.f_19606_, 1, -3), new MobEffectInstance(MobEffects.f_19610_, 1, 0), new MobEffectInstance(MobEffects.f_19612_, 2, 0), new MobEffectInstance(MobEffects.f_19613_, 1, 0), new MobEffectInstance(MobEffects.f_19615_, 1, 0), new MobEffectInstance(MobEffects.f_19620_, 1, 1), new MobEffectInstance(MobEffects.f_19614_, 1, 0)};

    @Nullable
    public static SpawnGroupData finalizeSpawn(LivingEntity entity, ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        ItemStack[] startingEquipment = MobHelper.captureEquipment(entity);
        ((ISpecialMob)entity).finalizeSpecialSpawn(levelAccessor, difficulty, spawnType, groupData);
        MobHelper.processSpawnEquipmentChanges(entity, startingEquipment, difficulty);
        return groupData;
    }

    public static ItemStack[] captureEquipment(LivingEntity entity) {
        EquipmentSlot[] slots = EquipmentSlot.values();
        ItemStack[] equipment = new ItemStack[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            equipment[i] = entity.m_6844_(slots[i]);
        }
        return equipment;
    }

    public static void processSpawnEquipmentChanges(LivingEntity entity, ItemStack[] oldEquipment, DifficultyInstance difficulty) {
        float diffMulti = difficulty.m_19057_();
        EquipmentSlot[] slots = EquipmentSlot.values();
        for (int i = 0; i < slots.length; ++i) {
            ItemStack newItem = entity.m_6844_(slots[i]);
            if (newItem.m_41619_() || ItemStack.m_41728_((ItemStack)newItem, (ItemStack)oldEquipment[i])) continue;
            float f = entity.m_217043_().m_188501_();
            float f2 = slots[i].m_20743_() == EquipmentSlot.Type.HAND ? 0.25f : 0.5f;
            if (!(f < f2 * diffMulti)) continue;
            entity.m_8061_(slots[i], EnchantmentHelper.m_220292_((RandomSource)entity.m_217043_(), (ItemStack)newItem, (int)((int)(5.0f + diffMulti * (float)entity.m_217043_().m_188503_(18))), (boolean)false));
        }
    }

    public static void charge(Creeper creeper) {
        if (creeper instanceof _SpecialCreeperEntity) {
            _SpecialCreeperEntity specialCreeper = (_SpecialCreeperEntity)creeper;
            specialCreeper.charge();
        } else {
            creeper.m_20088_().m_135381_(Creeper.f_32274_, (Object)true);
        }
    }

    public static boolean isDamageSourceIneffectiveAgainstVampires(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268490_) || source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            ItemStack weapon = ((LivingEntity)attacker).m_21205_();
            return !MobHelper.isWoodenTool(weapon) && !MobHelper.hasSmite(weapon);
        }
        return true;
    }

    public static float getVampireDamageBonus(DamageSource source) {
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            ItemStack weapon = ((LivingEntity)attacker).m_21205_();
            return weapon.m_204117_(SMTags.Items.GARLIC) ? 6.0f : 0.0f;
        }
        return 0.0f;
    }

    private static boolean isWoodenTool(ItemStack item) {
        if (item.m_41619_()) {
            return false;
        }
        return item.m_41720_() instanceof TieredItem && ((TieredItem)item.m_41720_()).m_43314_() == Tiers.WOOD || item.m_41720_() instanceof BowItem || item.m_41720_() instanceof CrossbowItem;
    }

    private static boolean hasSmite(ItemStack item) {
        return EnchantmentHelper.m_44833_((ItemStack)item, (MobType)MobType.f_21641_) > 0.0f;
    }

    public static void pull(@Nullable Entity angler, @Nullable Entity fish, double power) {
        if (angler instanceof LivingEntity && fish instanceof LivingEntity) {
            fish.m_20256_(fish.m_20184_().m_82490_(0.2).m_82520_((angler.m_20185_() - fish.m_20185_()) * power, Math.min((angler.m_20186_() - fish.m_20186_()) * power + Math.sqrt(fish.m_20270_(angler)) * 0.1, 2.0), (angler.m_20189_() - fish.m_20189_()) * power));
            fish.f_19864_ = true;
            ((LivingEntity)angler).m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    public static void knockback(Entity source, LivingEntity target, float power, float upwardMulti) {
        MobHelper.knockback(source, 0.6, target, power, upwardMulti, 0.5);
    }

    public static void knockback(Entity source, double sourceMomentum, LivingEntity target, float power, float upwardMulti, double momentum) {
        float angle = source.m_146908_() * (float)Math.PI / 180.0f;
        MobHelper.knockback(target, power, upwardMulti, (double)Mth.m_14031_((float)angle), (double)(-Mth.m_14089_((float)angle)), momentum);
        source.m_20256_(source.m_20184_().m_82542_(sourceMomentum, 1.0, sourceMomentum));
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti) {
        MobHelper.knockback(target, power, upwardMulti, 0.5);
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti, double momentum) {
        float angle = target.m_146908_() * (float)Math.PI / 180.0f;
        MobHelper.knockback(target, power, upwardMulti, (double)(-Mth.m_14031_((float)angle)), (double)Mth.m_14089_((float)angle), momentum);
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti, double forwardX, double forwardZ) {
        MobHelper.knockback(target, power, upwardMulti, forwardX, forwardZ, 0.5);
    }

    public static void knockback(LivingEntity target, float power, float upwardMulti, double forwardX, double forwardZ, double momentum) {
        LivingKnockBackEvent event;
        LivingKnockBackEvent livingKnockBackEvent = event = power < 0.0f ? ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)(-power * 0.5f), (double)(-forwardX), (double)(-forwardZ)) : ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)(power * 0.5f), (double)forwardX, (double)forwardZ);
        if (event.isCanceled()) {
            return;
        }
        power = (float)((double)event.getStrength() * (1.0 - target.m_21133_(Attributes.f_22278_)));
        if (power > 0.0f) {
            target.f_19812_ = true;
            Vec3 v = target.m_20184_().m_82490_(momentum);
            Vec3 vKB = new Vec3(-event.getRatioX(), 0.0, -event.getRatioZ()).m_82541_().m_82490_((double)power);
            double vY = v.f_82480_ + (double)(power * upwardMulti);
            target.m_20334_(v.f_82479_ + vKB.f_82479_, target.m_20096_() ? Math.max(0.2, vY) : vY, v.f_82481_ + vKB.f_82481_);
            target.f_19864_ = true;
        }
    }

    public static void causeLifeLoss(LivingEntity target, float amount) {
        float currentHealth = target.m_21223_();
        if (currentHealth > 1.0f) {
            target.m_21153_(Math.max(1.0f, currentHealth - amount));
        }
    }

    public static void stealLife(LivingEntity attacker, LivingEntity target, float amount) {
        float currentHealth = target.m_21223_();
        if (currentHealth > 1.0f) {
            float newHealth = Math.max(1.0f, currentHealth - amount);
            target.m_21153_(newHealth);
            attacker.m_5634_(currentHealth - newHealth);
        }
    }

    public static ItemStack stealRandomFood(Player player) {
        ArrayList<Integer> foodSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            ItemStack item = player.m_150109_().m_8020_(slot);
            if (item.m_41619_() || item.m_41720_().getFoodProperties(item, null) == null) continue;
            foodSlots.add(slot);
        }
        if (!foodSlots.isEmpty()) {
            return player.m_150109_().m_7407_(((Integer)foodSlots.get(player.m_217043_().m_188503_(foodSlots.size()))).intValue(), 1);
        }
        return ItemStack.f_41583_;
    }

    public static void stealBuffEffect(LivingEntity attacker, LivingEntity target) {
        if (!attacker.m_9236_().m_5776_()) {
            for (MobEffectInstance potion : target.m_21220_()) {
                if (potion == null || potion.m_19544_().m_19483_() == MobEffectCategory.HARMFUL || potion.m_19564_() < 0) continue;
                target.m_21195_(potion.m_19544_());
                attacker.m_7292_(new MobEffectInstance(potion.m_19544_(), Math.max(potion.m_19557_(), 200), potion.m_19564_()));
                return;
            }
        }
    }

    public static void removeNightVision(LivingEntity target) {
        target.m_21195_(MobEffects.f_19611_);
    }

    public static void applyPlagueEffect(LivingEntity target, RandomSource random) {
        MobHelper.applyEffectFromTemplate(target, PLAGUE_EFFECTS[random.m_188503_(PLAGUE_EFFECTS.length - (Config.MAIN.GENERAL.enableNausea.get() ? 0 : 1))]);
    }

    public static void applyWitchSpiderEffect(LivingEntity target, RandomSource random, boolean includePoison) {
        MobHelper.applyEffectFromTemplate(target, WITCH_EFFECTS[random.m_188503_(WITCH_EFFECTS.length - (includePoison ? 0 : 1))]);
    }

    public static void applyEffect(LivingEntity target, MobEffect effect) {
        MobHelper.applyEffect(target, effect, 1, 1.0f);
    }

    public static void applyEffect(LivingEntity target, MobEffect effect, int level) {
        MobHelper.applyEffect(target, effect, level, 1.0f);
    }

    public static void applyEffect(LivingEntity target, MobEffect effect, float durationMulti) {
        MobHelper.applyEffect(target, effect, 1, durationMulti);
    }

    public static void applyEffect(LivingEntity target, MobEffect effect, int level, float durationMulti) {
        MobHelper.applyEffect(target, effect, level, effect.m_8093_() ? 1 : (int)((float)MobHelper.defaultEffectDuration(target.m_9236_().m_46791_()) * durationMulti));
    }

    public static void applyDurationEffect(LivingEntity target, MobEffect effect, int duration) {
        MobHelper.applyEffect(target, effect, 1, duration);
    }

    public static void applyEffect(LivingEntity target, MobEffect effect, int level, int duration) {
        target.m_7292_(new MobEffectInstance(effect, duration, level - 1));
    }

    public static void applyEffectFromTemplate(LivingEntity target, MobEffectInstance template) {
        MobHelper.applyEffectFromTemplate(target, template, MobHelper.defaultEffectDuration(target.m_9236_().m_46791_()));
    }

    public static void applyEffectFromTemplate(LivingEntity target, MobEffectInstance template, int baseDuration) {
        target.m_7292_(new MobEffectInstance(template.m_19544_(), template.m_19544_().m_8093_() ? 1 : baseDuration * template.m_19557_(), template.m_19564_()));
    }

    public static AbstractArrow tipPlagueArrow(AbstractArrow arrow, RandomSource random) {
        return MobHelper.tipArrowFromTemplate(arrow, PLAGUE_EFFECTS[random.m_188503_(PLAGUE_EFFECTS.length - (Config.MAIN.GENERAL.enableNausea.get() ? 0 : 1))]);
    }

    public static AbstractArrow tipArrow(AbstractArrow arrow, MobEffect effect) {
        return MobHelper.tipArrow(arrow, effect, 1, 1.0f);
    }

    public static AbstractArrow tipArrow(AbstractArrow arrow, MobEffect effect, int level) {
        return MobHelper.tipArrow(arrow, effect, level, 1.0f);
    }

    public static AbstractArrow tipArrow(AbstractArrow arrow, MobEffect effect, float durationMulti) {
        return MobHelper.tipArrow(arrow, effect, 1, durationMulti);
    }

    public static AbstractArrow tipArrow(AbstractArrow arrow, MobEffect effect, int level, float durationMulti) {
        return MobHelper.tipArrow(arrow, effect, level, effect.m_8093_() ? 1 : (int)((float)MobHelper.defaultEffectDuration(arrow.m_9236_().m_46791_()) * durationMulti));
    }

    public static AbstractArrow tipArrow(AbstractArrow arrow, MobEffect effect, int level, int duration) {
        if (arrow instanceof Arrow) {
            Arrow arrow1 = (Arrow)arrow;
            arrow1.m_36870_(new MobEffectInstance(effect, duration, level - 1));
        }
        return arrow;
    }

    public static AbstractArrow tipArrowFromTemplate(AbstractArrow arrow, MobEffectInstance template) {
        return MobHelper.tipArrowFromTemplate(arrow, template, MobHelper.defaultEffectDuration(arrow.m_9236_().m_46791_()));
    }

    public static AbstractArrow tipArrowFromTemplate(AbstractArrow arrow, MobEffectInstance template, int baseDuration) {
        if (arrow instanceof Arrow) {
            Arrow arrow1 = (Arrow)arrow;
            arrow1.m_36870_(new MobEffectInstance(template.m_19544_(), template.m_19544_().m_8093_() ? 1 : baseDuration * template.m_19557_(), template.m_19564_()));
        }
        return arrow;
    }

    public static ItemStack tridentWithEffect(MobEffect effect, int level, int duration) {
        ItemStack trident = new ItemStack((ItemLike)Items.f_42713_);
        CompoundTag stackTag = trident.m_41784_();
        CompoundTag modTag = new CompoundTag();
        CompoundTag effectTag = new CompoundTag();
        MobEffectInstance instance = new MobEffectInstance(effect, duration, level - 1);
        instance.m_19555_(effectTag);
        modTag.m_128365_("TridentEffect", (Tag)effectTag);
        stackTag.m_128365_("special_mobs_ModData", (Tag)modTag);
        return trident;
    }

    @Nullable
    public static MobEffectInstance getTridentEffect(ItemStack tridentStack) {
        CompoundTag modTag;
        if (tridentStack.m_41720_() != Items.f_42713_) {
            return null;
        }
        if (tridentStack.m_41782_() && tridentStack.m_41783_().m_128425_("special_mobs_ModData", 10) && (modTag = tridentStack.m_41783_().m_128469_("special_mobs_ModData")).m_128425_("TridentEffect", 10)) {
            return MobEffectInstance.m_19560_((CompoundTag)modTag.m_128469_("TridentEffect"));
        }
        return null;
    }

    public static int defaultEffectDuration(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.PEACEFUL, Difficulty.EASY -> 60;
            case Difficulty.NORMAL -> 140;
            default -> 300;
        };
    }

    public static boolean tryBlockAttack(LivingEntity blocker, DamageSource source, boolean needsShield) {
        AbstractArrow arrow;
        Entity attacker;
        if (blocker.m_9236_().m_5776_() || blocker.m_6673_(source) || source.m_269533_(DamageTypeTags.f_268490_)) {
            return false;
        }
        if (blocker.m_217043_().m_188501_() >= 0.33f && ((attacker = source.m_7639_()) == null || blocker.m_20280_(attacker) < 36.0)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
            return false;
        }
        InteractionHand shieldHand = InteractionHand.OFF_HAND;
        ItemStack shield = blocker.m_21120_(shieldHand);
        if (!(!needsShield || !shield.m_41619_() && shield.canPerformAction(ToolActions.SHIELD_BLOCK) || !(shield = blocker.m_21120_(shieldHand = InteractionHand.MAIN_HAND)).m_41619_() && shield.canPerformAction(ToolActions.SHIELD_BLOCK))) {
            return false;
        }
        Vec3 sourcePos = source.m_7270_();
        if (sourcePos != null) {
            Vec3 lookVec = blocker.m_20252_(1.0f);
            Vec3 targetVec = sourcePos.m_82505_(blocker.m_20182_()).m_82541_();
            targetVec = new Vec3(targetVec.f_82479_, 0.0, targetVec.f_82481_);
            if (targetVec.m_82526_(lookVec) < 0.0) {
                blocker.m_9236_().m_6263_(null, blocker.m_20185_() + 0.5, blocker.m_20186_(), blocker.m_20189_() + 0.5, SoundEvents.f_12346_, SoundSource.NEUTRAL, 0.9f, 1.0f);
                if (needsShield && entity instanceof Player) {
                    Player player = (Player)entity;
                    MobHelper.maybeDestroyShield(blocker, shield, shieldHand, player.m_21205_());
                }
                if (!source.m_269533_(DamageTypeTags.f_268524_) && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147240_(0.5, blocker.m_20185_() - entity.m_20185_(), blocker.m_20189_() - entity.m_20189_());
                    entity.f_19864_ = true;
                }
                return true;
            }
        }
        return false;
    }

    private static void maybeDestroyShield(LivingEntity blocker, ItemStack shield, InteractionHand shieldHand, ItemStack weapon) {
        if (!weapon.m_41619_() && !shield.m_41619_() && weapon.m_41720_() instanceof AxeItem && shield.m_41720_() == Items.f_42740_ && blocker.m_217043_().m_188501_() < 0.25f - (float)EnchantmentHelper.m_44926_((LivingEntity)blocker) * 0.05f) {
            blocker.m_9236_().m_6263_(null, blocker.m_20185_() + 0.5, blocker.m_20186_(), blocker.m_20189_() + 0.5, SoundEvents.f_12347_, SoundSource.NEUTRAL, 0.9f, 1.0f);
            blocker.m_21190_(shieldHand);
            blocker.m_21008_(shieldHand, ItemStack.f_41583_);
        }
    }

    public static void floatInFluid(Entity entity, double acceleration, FluidType fluidType) {
        if (entity.f_19797_ > 1 && entity.getFluidTypeHeight(fluidType) > 0.0) {
            if (CollisionContext.m_82750_((Entity)entity).m_6513_(LiquidBlock.f_54690_, entity.m_20183_(), true) && entity.m_9236_().m_6425_(entity.m_20183_().m_7494_()).getFluidType() != fluidType) {
                entity.m_6853_(true);
            } else {
                entity.m_20256_(entity.m_20184_().m_82490_(0.5).m_82520_(0.0, acceleration, 0.0));
            }
        }
    }

    public static void updateFrostWalker(LivingEntity entity, BlockPos pos) {
        MobHelper.updateFrostWalker(entity, pos, 1);
    }

    public static void updateFrostWalker(LivingEntity entity, BlockPos pos, int level) {
        boolean actualOnGround = entity.m_20096_();
        entity.m_6853_(true);
        FrostWalkerEnchantment.m_45018_((LivingEntity)entity, (Level)entity.m_9236_(), (BlockPos)pos, (int)level);
        entity.m_6853_(actualOnGround);
    }

    public static void hopOnFluid(Entity entity) {
        if (entity.f_19797_ > 1 && entity.m_9236_().f_46441_.m_188503_(10) == 0 && CollisionContext.m_82750_((Entity)entity).m_6513_(LiquidBlock.f_54690_, entity.m_20183_(), true) && entity.m_9236_().m_6425_(entity.m_20183_()).m_205070_(FluidTags.f_13131_) && !entity.m_9236_().m_6425_(entity.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
            BlockState block = entity.m_9236_().m_8055_(entity.m_20183_());
            if (!(block.m_60795_() || block.m_280296_() || block.m_60819_().m_76178_())) {
                BlockEntity blockEntity = block.m_155947_() ? entity.m_9236_().getExistingBlockEntity(entity.m_20183_()) : null;
                Block.m_49892_((BlockState)block, (LevelAccessor)entity.m_9236_(), (BlockPos)entity.m_20183_(), (BlockEntity)blockEntity);
                entity.m_9236_().m_7731_(entity.m_20183_(), Blocks.f_49990_.m_49966_(), 3);
            }
            entity.m_20256_(entity.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.4, 0.0));
        }
    }

    public static void hopOntoShore(Entity entity, TagKey<Fluid> fluidTag) {
        if (entity.f_19797_ > 1 && entity.m_9236_().f_46441_.m_188503_(10) == 0 && CollisionContext.m_82750_((Entity)entity).m_6513_(LiquidBlock.f_54690_, entity.m_20183_(), true) && !entity.m_9236_().m_6425_(entity.m_20183_().m_7494_()).m_205070_(fluidTag)) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState neighborState = entity.m_9236_().m_8055_(entity.m_20183_().m_121945_(dir));
                if (!neighborState.m_280296_() || entity.m_6350_() != dir) continue;
                entity.m_20256_(entity.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.4, 0.0));
            }
        }
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, BlockState block) {
        return MobHelper.placeBlock(entity, pos, block, 3);
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, Direction direction, BlockState block) {
        return MobHelper.placeBlock(entity, pos, direction, block, 3);
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, BlockState block, int updateFlags) {
        return MobHelper.placeBlock(entity, pos, Direction.UP, block, updateFlags);
    }

    public static boolean placeBlock(Entity entity, BlockPos pos, Direction direction, BlockState block, int updateFlags) {
        if (MobHelper.canPlaceBlock(entity, pos, direction)) {
            entity.m_9236_().m_7731_(pos, block, updateFlags);
            return true;
        }
        return false;
    }

    public static boolean canPlaceBlock(Entity entity, BlockPos pos) {
        return MobHelper.canPlaceBlock(entity, pos, Direction.UP);
    }

    public static boolean canPlaceBlock(Entity entity, BlockPos pos, Direction direction) {
        return !ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)BlockSnapshot.create((ResourceKey)entity.m_9236_().m_46472_(), (LevelAccessor)entity.m_9236_(), (BlockPos)pos), (Direction)direction);
    }
}

