/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.core.register;

import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.block.UnderwaterSilverfishBlock;
import fathertoast.specialmobs.common.core.register.SMItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SMBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"specialmobs");
    public static final RegistryObject<Block> MELTING_ICE = SMBlocks.registerTechnicalBlock("melting_ice", MeltingIceBlock::new);
    public static final List<RegistryObject<Block>> INFESTED_CORAL;

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier, ResourceKey<CreativeModeTab> creativeTab) {
        RegistryObject blockRegObject = REGISTRY.register(name, blockSupplier);
        SMItems.REGISTRY.register(name, () -> new BlockItem((Block)blockRegObject.get(), new Item.Properties()));
        return blockRegObject;
    }

    private static <T extends Block> RegistryObject<T> registerTechnicalBlock(String name, Supplier<T> blockSupplier) {
        RegistryObject blockRegObject = REGISTRY.register(name, blockSupplier);
        SMItems.REGISTRY.register(name, () -> new BlockItem((Block)blockRegObject.get(), new Item.Properties()));
        return blockRegObject;
    }

    static {
        ArrayList<RegistryObject<Block>> infestedCoral = new ArrayList<RegistryObject<Block>>();
        for (UnderwaterSilverfishBlock.Type type : UnderwaterSilverfishBlock.Type.values()) {
            infestedCoral.add(SMBlocks.registerBlock(type.blockId(), type::blockSupplier, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_));
        }
        infestedCoral.trimToSize();
        INFESTED_CORAL = Collections.unmodifiableList(infestedCoral);
    }
}

