/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;

public class WildsWitchSpeciesConfig
extends SpeciesConfig {
    public final Wilds WILDS;

    public WildsWitchSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, int minMounts, int maxMounts, int minSwarms, int maxSwarms, int minSwarmSize, int maxSwarmSize) {
        super(manager, species);
        this.WILDS = new Wilds(this, species, species.getConfigName(), minMounts, maxMounts, minSwarms, maxSwarms, minSwarmSize, maxSwarmSize);
    }

    public static class Wilds
    extends AbstractConfigCategory<WildsWitchSpeciesConfig> {
        public final IntField.RandomRange mounts;
        public final IntField.RandomRange swarms;
        public final IntField.RandomRange swarmSize;

        Wilds(WildsWitchSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, int minMounts, int maxMounts, int minSwarms, int maxSwarms, int minSwarmSize, int maxSwarmSize) {
            super((AbstractConfigFile)parent, ConfigUtil.camelCaseToLowerUnderscore((String)species.specialVariantName), new String[]{"Options specific to " + speciesName + "."});
            this.mounts = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("mounts.min", minMounts, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of times " + speciesName + " can summon a spider mount."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("mounts.max", maxMounts, IntField.Range.NON_NEGATIVE, new String[0])));
            this.SPEC.newLine();
            this.swarms = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("swarms.min", minSwarms, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of times " + speciesName + " can summon a spider swarm."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("swarms.max", maxSwarms, IntField.Range.NON_NEGATIVE, new String[0])));
            this.SPEC.newLine();
            this.swarmSize = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("swarm_size.min", minSwarmSize, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of spiders " + speciesName + " spawn with each swarm.", "Note that this is rolled on the summoner's spawn, not each time a swarm is summoned."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("swarm_size.max", maxSwarmSize, IntField.Range.NON_NEGATIVE, new String[0])));
        }
    }
}

