/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.BlazeSpeciesConfig;

public class WildfireBlazeSpeciesConfig
extends BlazeSpeciesConfig {
    public final Wildfire WILDFIRE;

    public WildfireBlazeSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, int fireballBurstCount, int fireballBurstDelay, int minBabies, int maxBabies, int minSummons, int maxSummons) {
        super(manager, species, fireballBurstCount, fireballBurstDelay);
        this.WILDFIRE = new Wildfire(this, species, species.getConfigName(), minBabies, maxBabies, minSummons, maxSummons);
    }

    public static class Wildfire
    extends AbstractConfigCategory<WildfireBlazeSpeciesConfig> {
        public final IntField.RandomRange babies;
        public final IntField.RandomRange summons;

        Wildfire(WildfireBlazeSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, int minBabies, int maxBabies, int minSummons, int maxSummons) {
            super((AbstractConfigFile)parent, ConfigUtil.camelCaseToLowerUnderscore((String)species.specialVariantName), new String[]{"Options specific to " + speciesName + "."});
            this.babies = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("babies.min", minBabies, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of babies " + speciesName + " spawn on death."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("babies.max", maxBabies, IntField.Range.NON_NEGATIVE, new String[0])));
            this.SPEC.newLine();
            this.summons = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("summons.min", minSummons, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of times " + speciesName + " can summon minions."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("summons.max", maxSummons, IntField.Range.NON_NEGATIVE, new String[0])));
        }
    }
}

