/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;

public class SkeletonSpeciesConfig
extends SpeciesConfig {
    public final Skeletons SKELETONS;

    public SkeletonSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, double bowChance, double shieldChance) {
        super(manager, species);
        this.SKELETONS = new Skeletons(this, species, species.getConfigName(), bowChance, shieldChance);
    }

    public static class Skeletons
    extends AbstractConfigCategory<SkeletonSpeciesConfig> {
        public final DoubleField bowEquipChance;
        public final DoubleField shieldEquipChance;

        Skeletons(SkeletonSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, double bowChance, double shieldChance) {
            super((AbstractConfigFile)parent, ConfigUtil.noSpaces((String)species.family.configName), new String[]{"Options standard to all " + species.family.configName + "."});
            double effectiveDefault = species.bestiaryInfo.rangedAttackMaxRange > 0.0 ? bowChance : 0.0;
            this.bowEquipChance = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("bow_chance", effectiveDefault, DoubleField.Range.PERCENT, new String[]{"Chance for " + speciesName + " to spawn with a bow, which enables their ranged attack (if max range > 0)."}));
            this.SPEC.newLine();
            this.shieldEquipChance = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("shield_chance", shieldChance, DoubleField.Range.PERCENT, new String[]{"Chance for " + speciesName + " to spawn with a shield if they did not spawn with a bow.", "Shield users have a 33% chance to block frontal attacks (100% vs. long range attacks) and can be broken by axes."}));
        }
    }
}

