/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.CreeperSpeciesConfig;

public class DrowningCreeperSpeciesConfig
extends CreeperSpeciesConfig {
    public final Drowning DROWNING;

    public DrowningCreeperSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, boolean cannotExplodeWhileWet, boolean explodeWhileBurning, boolean explodeWhenShot, double infestedChance, int minPuffPuffs, int maxPuffPuffs) {
        super(manager, species, cannotExplodeWhileWet, explodeWhileBurning, explodeWhenShot);
        this.DROWNING = new Drowning(this, species, species.getConfigName(), infestedChance, minPuffPuffs, maxPuffPuffs);
    }

    public static class Drowning
    extends AbstractConfigCategory<DrowningCreeperSpeciesConfig> {
        public final DoubleField infestedBlockChance;
        public final IntField.RandomRange puffPuffs;

        Drowning(DrowningCreeperSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, double infestedChance, int minPuffPuffs, int maxPuffPuffs) {
            super((AbstractConfigFile)parent, ConfigUtil.camelCaseToLowerUnderscore((String)species.specialVariantName), new String[]{"Options specific to " + speciesName + "."});
            this.infestedBlockChance = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("infested_chance", infestedChance, DoubleField.Range.PERCENT, new String[]{"Chance for explosion's coral shell blocks to be infested with aquatic silverfish. Rolled for each coral block generated."}));
            this.SPEC.newLine();
            this.puffPuffs = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("pufferfish.min", minPuffPuffs, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) limit on the number of pufferfish that " + speciesName + " spawn with their explosion."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("pufferfish.max", maxPuffPuffs, IntField.Range.NON_NEGATIVE, new String[0])));
        }
    }
}

