/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;

public class BlazeSpeciesConfig
extends SpeciesConfig {
    public final Blazes BLAZES;

    public BlazeSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, int fireballBurstCount, int fireballBurstDelay) {
        super(manager, species);
        this.BLAZES = new Blazes(this, species, species.getConfigName(), fireballBurstCount, fireballBurstDelay);
    }

    public static class Blazes
    extends AbstractConfigCategory<BlazeSpeciesConfig> {
        public final IntField fireballBurstCount;
        public final IntField fireballBurstDelay;

        Blazes(BlazeSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, int burstCount, int burstDelay) {
            super((AbstractConfigFile)parent, ConfigUtil.noSpaces((String)species.family.configName), new String[]{"Options standard to all " + species.family.configName + "."});
            this.fireballBurstCount = (IntField)this.SPEC.define((AbstractConfigField)new IntField("fireball_attack.burst_count", burstCount, IntField.Range.NON_NEGATIVE, new String[]{"The number of fireballs " + speciesName + " launch with each burst."}));
            this.fireballBurstDelay = (IntField)this.SPEC.define((AbstractConfigField)new IntField("fireball_attack.burst_delay", burstDelay, IntField.Range.NON_NEGATIVE, new String[]{"The time (in ticks) " + speciesName + " wait between each fireball in a burst. (20 ticks = 1 second)"}));
        }
    }
}

