/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.family;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.EnvironmentListField;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import java.util.ArrayList;
import java.util.List;

public class FamilyConfig
extends AbstractConfigFile {
    protected static final double VARIANT_CHANCE_LOW = 0.2;
    protected static final double VARIANT_CHANCE_HIGH = 0.33;
    public final General GENERAL;

    public static String dir(MobFamily<?, ?> family) {
        return ConfigUtil.noSpaces((String)family.configName);
    }

    protected static String fileName(MobFamily<?, ?> family) {
        return "_family_of_" + ConfigUtil.noSpaces((String)family.configName);
    }

    public static FamilyConfig newLessSpecial(ConfigManager manager, MobFamily<?, ?> family) {
        return new FamilyConfig(manager, family, 0.2);
    }

    public static FamilyConfig newMoreSpecial(ConfigManager manager, MobFamily<?, ?> family) {
        return new FamilyConfig(manager, family, 0.33);
    }

    public FamilyConfig(ConfigManager manager, MobFamily<?, ?> family) {
        this(manager, family, 0.25);
    }

    public FamilyConfig(ConfigManager manager, MobFamily<?, ?> family, double variantChance) {
        super(manager, ConfigUtil.noSpaces((String)family.configName) + "/" + FamilyConfig.fileName(family), new String[]{"This config contains options that apply to the family of " + family.configName + " as a whole; that is, the vanilla replacement and all special variants."});
        this.GENERAL = new General(this, family, variantChance);
    }

    public static class General
    extends AbstractConfigCategory<FamilyConfig> {
        public final BooleanField vanillaReplacement;
        public final DoubleField familyRandomScaling;
        public final DoubleField.EnvironmentSensitive specialVariantChance;
        public final DoubleField.EnvironmentSensitiveWeightedList<MobFamily.Species<?>> specialVariantList;

        General(FamilyConfig parent, MobFamily<?, ?> family, double variantChance) {
            super((AbstractConfigFile)parent, "general", new String[]{"Options standard to all mob families (that is, not specific to any particular mob family)."});
            int i;
            this.vanillaReplacement = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("vanilla_replacement", true, new String[]{"Whether this mob family replaces vanilla " + family.configName + " with its vanilla replacement species.", "The \"master_vanilla_replacement\" setting in the mod's main config must also be true for this to work."}));
            this.SPEC.newLine();
            this.familyRandomScaling = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("family_random_scaling", -1.0, DoubleField.Range.SIGNED_PERCENT, new String[]{"When greater than 0, " + family.configName + " will have a random render scale applied. This is a visual effect only. If this is set to a non-negative value, it overrides the value set for \"master_random_scaling\", though species configs can override this value."}));
            this.SPEC.newLine();
            this.specialVariantChance = new DoubleField.EnvironmentSensitive((DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("special_variant_chance.base", variantChance, DoubleField.Range.PERCENT, new String[]{"The chance for " + family.configName + " to spawn as special variants.", "NOTE: Some environment check types can cause deadlocks on servers currently, so be careful!"})), (EnvironmentListField)this.SPEC.define((AbstractConfigField)new EnvironmentListField("special_variant_chance.exceptions", new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((CrustConfigSpec)this.SPEC, (float)((float)variantChance * 0.5f)).beforeDays(5).build(), EnvironmentEntry.builder((CrustConfigSpec)this.SPEC, (float)((float)variantChance * 2.0f)).atMaxMoonLight().build(), EnvironmentEntry.builder((CrustConfigSpec)this.SPEC, (float)((float)variantChance * 1.5f)).atMaxMoonLight().build()}).setRange(DoubleField.Range.PERCENT), new String[]{"The chance for " + family.configName + " to spawn as special variants when specific environmental conditions are met."})));
            this.SPEC.newLine();
            DoubleField[] baseWeights = new DoubleField[family.variants.length];
            EnvironmentListField[] weightExceptions = new EnvironmentListField[family.variants.length];
            ArrayList comment = TomlHelper.newComment((String[])new String[]{"The weight of each " + ConfigUtil.camelCaseToLowerSpace((String)family.name) + " species to be chosen as the replacement when " + family.configName + " spawn as special variants. Higher weight is more common."});
            comment.add(TomlHelper.multiFieldInfo((DoubleField.Range)DoubleField.Range.NON_NEGATIVE));
            this.SPEC.comment((List)comment);
            for (i = 0; i < family.variants.length; ++i) {
                baseWeights[i] = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("weight." + ConfigUtil.camelCaseToLowerUnderscore((String)family.variants[i].specialVariantName) + ".base", family.variants[i].bestiaryInfo.defaultWeight.value, DoubleField.Range.NON_NEGATIVE, (String[])null));
            }
            this.SPEC.newLine();
            comment = TomlHelper.newComment((String[])new String[]{"The weight of each " + ConfigUtil.camelCaseToLowerSpace((String)family.name) + " species to be chosen as the replacement when " + family.configName + " spawn as special variants when specific environmental conditions are met. Higher weight is more common."});
            comment.add(TomlHelper.multiFieldInfo((DoubleField.Range)DoubleField.Range.NON_NEGATIVE));
            this.SPEC.comment((List)comment);
            for (i = 0; i < family.variants.length; ++i) {
                weightExceptions[i] = (EnvironmentListField)this.SPEC.define((AbstractConfigField)new EnvironmentListField("weight." + ConfigUtil.camelCaseToLowerUnderscore((String)family.variants[i].specialVariantName) + ".exceptions", family.variants[i].bestiaryInfo.theme.getValue(), (String[])null));
            }
            this.specialVariantList = new DoubleField.EnvironmentSensitiveWeightedList((Object[])family.variants, baseWeights, weightExceptions);
        }
    }
}

