/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.EnvironmentListField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.field.RestartNote;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;

public class MainConfig
extends AbstractConfigFile {
    public final General GENERAL = new General(this);
    public final NaturalSpawning NATURAL_SPAWNING = new NaturalSpawning(this);

    MainConfig(ConfigManager manager, String fileName) {
        super(manager, fileName, new String[]{"This config contains options that apply to the mod as a whole, including some master settings toggles for convenience."});
    }

    public static class General
    extends AbstractConfigCategory<MainConfig> {
        public final BooleanField enableMobReplacement;
        public final BooleanField enableNaturalSpawning;
        public final BooleanField skipSpawnerSpawns;
        public final BooleanField masterVanillaReplacement;
        public final DoubleField masterRandomScaling;
        public final BooleanField enableNausea;
        public final BooleanField fancyFishingMobs;

        General(MainConfig parent) {
            super((AbstractConfigFile)parent, "general", new String[]{"Options that apply to the Special Mobs mod as a whole. Also includes several 'master toggles' for convenience."});
            this.enableMobReplacement = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("enable_mob_replacer", true, new String[]{"Whether the Mob Replacer is enabled. This 'hijacks' vanilla mob spawns to use as its own.", "The Mob Replacer is the traditional spawn method for Special Mobs which allows everything that spawns valid vanilla mobs (e.g. dungeon spawners) to spawn this mod's mobs based on your configs instead."}));
            this.enableNaturalSpawning = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("enable_added_natural_spawning", true, new String[]{"Whether the natural spawning category (see below) is enabled."}));
            this.SPEC.newLine();
            this.skipSpawnerSpawns = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("skip_spawner_spawns", false, new String[]{"If enabled, mobs spawned from spawner blocks/dungeon spawners will not be subject to mob replacement."}));
            this.SPEC.newLine();
            this.masterVanillaReplacement = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("master_vanilla_replacement", true, new String[]{"Whether the mod uses Special Mobs entities in place of vanilla entities for non-special species. This allows your config options to apply to non-special species and allows them to benefit from Special Mob Data and any improvements made to the entity (for example, zombies can use bows & shields).", "If false, vanilla replacements are disabled for all families; if true, it is determined by the family's config."}));
            this.masterRandomScaling = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("master_random_scaling", 0.07, DoubleField.Range.PERCENT, new String[]{"When greater than 0, mobs will have a random render scale applied. This is a visual effect only. For example, with a value of 0.07, mob scale will vary \u00b17% of normal size.", "By default, this applies to all mobs in the mod; but family and species configs can override it."}));
            this.SPEC.newLine();
            this.enableNausea = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("enable_nausea_effects", true, new String[]{"Set to false to prevent any of this mod's mobs from applying nausea (aka confusion). Use this if the screen warping from nausea hurts your face or makes you sick."}));
            this.fancyFishingMobs = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("fancy_fishing_mobs", true, new String[]{"Overrides the default fishing rod item animation so that it is compatible with fishing mobs from this mod. Set to false if it causes problems with another mod. Fishing mobs will instead render a stick while casting."}), RestartNote.GAME);
        }
    }

    public static class NaturalSpawning
    extends AbstractConfigCategory<MainConfig> {
        public final DoubleField caveSpiderSpawnMultiplier;
        public final DoubleField.EnvironmentSensitive caveSpiderSpawnChance;
        public final IntField drowningCreeperOceanWeight;
        public final IntField drowningCreeperRiverWeight;
        public final IntField pirateSkeletonOceanWeight;
        public final IntField pirateSkeletonRiverWeight;
        public final IntField blueberrySlimeOceanWeight;
        public final IntField blueberrySlimeRiverWeight;
        public final IntField witherSkeletonNetherWeight;
        public final IntField witherSkeletonSoulSandValleyWeight;
        public final IntField blazeNetherWeight;
        public final IntField blazeBasaltDeltasWeight;
        public final IntField fireCreeperNetherWeight;
        public final IntField fireZombieNetherWeight;
        public final IntField fireSpiderNetherWeight;
        public final DoubleField enderCreeperSpawnMultiplier;

        NaturalSpawning(MainConfig parent) {
            super((AbstractConfigFile)parent, "natural_spawning", new String[]{"Options to customize the additional natural monster spawning from this mod. Most changes to options in this category require the game to be restarted to take effect."});
            this.SPEC.increaseIndent();
            this.SPEC.subcategory("general_spawns", new String[]{"Added natural spawns derived from existing spawns."});
            this.caveSpiderSpawnMultiplier = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("cave_spider_spawn_multiplier", 0.5, DoubleField.Range.NON_NEGATIVE, new String[]{"Option to add vanilla cave spiders as natural spawns. These spawns will be added to all biomes that can spawn regular spiders. Cave spider spawn weight is the same as the spider spawn weight, multiplied by this value. When set to 0, the added cave spider spawn feature is completely disabled. Finer tuning can be done with the spawn chances below."}), RestartNote.GAME_PARTIAL);
            this.caveSpiderSpawnChance = new DoubleField.EnvironmentSensitive((DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("cave_spider_chance.base", 0.0, DoubleField.Range.PERCENT, new String[]{"The chance for added cave spider natural spawn attempts to succeed. Does not affect Mob Replacement."})), (EnvironmentListField)this.SPEC.define((AbstractConfigField)new EnvironmentListField("cave_spider_chance.exceptions", new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((CrustConfigSpec)this.SPEC, (float)1.0f).belowDiamondLevel().build(), EnvironmentEntry.builder((CrustConfigSpec)this.SPEC, (float)1.0f).inStructure(BuiltinStructures.f_209846_).build(), EnvironmentEntry.builder((CrustConfigSpec)this.SPEC, (float)0.33f).belowSeaFloor().build()}).setRange(DoubleField.Range.PERCENT), new String[]{"The chance for added cave spider natural spawn attempts to succeed when specific environmental conditions are met."})));
            this.SPEC.newLine();
            this.enderCreeperSpawnMultiplier = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("ender_creeper_spawn_multiplier", 0.1, DoubleField.Range.NON_NEGATIVE, new String[]{"Option to add ender creepers as natural spawns. These spawns will be added to all biomes that can spawn endermen. Ender creeper spawn weight is the same as the enderman weight, multiplied by this value. When set to 0, the added ender creeper spawn feature is completely disabled. Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.SPEC.subcategory("water_spawns", new String[0]);
            this.drowningCreeperOceanWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("drowning_creeper_weight.ocean", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add drowning creepers as natural spawns to oceans.", "When set to 0, this added spawn feature is completely disabled.", "Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.drowningCreeperRiverWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("drowning_creeper_weight.river", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add drowning creepers as natural spawns to rivers. When set to 0, this added spawn feature is completely disabled. Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.SPEC.newLine();
            this.pirateSkeletonOceanWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("pirate_skeleton_weight.ocean", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add pirate skeletons as natural spawns to oceans.", "When set to 0, this added spawn feature is completely disabled.", "Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.pirateSkeletonRiverWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("pirate_skeleton_weight.river", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add pirate skeletons as natural spawns to rivers. When set to 0, this added spawn feature is completely disabled. Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.SPEC.newLine();
            this.blueberrySlimeOceanWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("blueberry_slime_weight.ocean", 2, IntField.Range.NON_NEGATIVE, new String[]{"Option to add blueberry slimes as natural spawns to oceans. When set to 0, this added spawn feature is completely disabled. Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.blueberrySlimeRiverWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("blueberry_slime_weight.river", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add blueberry slimes as natural spawns to rivers. When set to 0, this added spawn feature is completely disabled. Finer tuning can be done with the natural spawn chances in the species config file."}), RestartNote.WORLD);
            this.SPEC.subcategory("nether_spawns", new String[0]);
            this.witherSkeletonNetherWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("wither_skeleton_weight.nether", 2, IntField.Range.NON_NEGATIVE, new String[]{"Option to add vanilla wither skeletons as natural spawns to the Nether (except for soul sand valley and warped forest biomes). When set to 0, this added spawn feature is completely disabled."}), RestartNote.WORLD);
            this.witherSkeletonSoulSandValleyWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("wither_skeleton_weight.soul_sand_valley", 5, IntField.Range.NON_NEGATIVE, new String[]{"Option to add vanilla wither skeletons as natural spawns to the soul sand valley biome. When set to 0, this added spawn feature is completely disabled."}), RestartNote.WORLD);
            this.SPEC.newLine();
            this.blazeNetherWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("blaze_weight.nether", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add vanilla blazes as natural spawns to the Nether (except for soul sand valley, warped forest, and basalt deltas biomes). When set to 0, the added blaze spawn feature is completely disabled."}), RestartNote.WORLD);
            this.blazeBasaltDeltasWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("blaze_weight.basalt_deltas", 20, IntField.Range.NON_NEGATIVE, new String[]{"Option to add vanilla blazes as natural spawns to the basalt deltas biome. When set to 0, the added blaze spawn feature is completely disabled."}), RestartNote.WORLD);
            this.SPEC.newLine();
            this.fireCreeperNetherWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("fire_creeper_weight.nether", 1, IntField.Range.NON_NEGATIVE, new String[]{"Option to add fire creepers, zombies, and spiders as natural spawns to the Nether (except for soul sand valley and warped forest biomes). When set to 0, that added spawn feature is completely disabled. Finer tuning can be done with the natural spawn chances in the species config files."}), RestartNote.WORLD);
            this.fireZombieNetherWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("fire_zombie_weight.nether", 1, IntField.Range.NON_NEGATIVE, (String[])null));
            this.fireSpiderNetherWeight = (IntField)this.SPEC.define((AbstractConfigField)new IntField("fire_spider_weight.nether", 1, IntField.Range.NON_NEGATIVE, (String[])null));
            this.SPEC.decreaseIndent();
        }
    }
}

