/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.block;

import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import fathertoast.specialmobs.common.entity.silverfish.PufferSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class UnderwaterSilverfishBlock
extends InfestedBlock {
    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return Type.getTranslationsFor(langKey);
    }

    public UnderwaterSilverfishBlock(Block block) {
        super(block, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50129_).m_60913_(0.0f, 0.75f));
    }

    protected void m_54180_(ServerLevel level, BlockPos pos) {
        PufferSilverfishEntity silverfish = (PufferSilverfishEntity)((EntityType)PufferSilverfishEntity.SPECIES.entityType.get()).m_20615_((Level)level);
        if (silverfish == null) {
            return;
        }
        silverfish.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        level.m_7967_((Entity)silverfish);
        silverfish.m_21373_();
    }

    public static enum Type {
        TUBE("tube", Blocks.f_50584_, langKey -> References.translations(langKey, "Infested Tube Coral Block", "", "", "", "", "", "")),
        BRAIN("brain", Blocks.f_50585_, langKey -> References.translations(langKey, "Infested Brain Coral Block", "", "", "", "", "", "")),
        BUBBLE("bubble", Blocks.f_50586_, langKey -> References.translations(langKey, "Infested Bubble Coral Block", "", "", "", "", "", "")),
        FIRE("fire", Blocks.f_50587_, langKey -> References.translations(langKey, "Infested Fire Coral Block", "", "", "", "", "", "")),
        HORN("horn", Blocks.f_50588_, langKey -> References.translations(langKey, "Infested Horn Coral Block", "", "", "", "", "", ""));

        private final String ID;
        private final Block HOST_BLOCK;
        private final Function<String, String[]> TRANSLATIONS;

        private Type(String id, Block hostBlock, Function<String, String[]> translations) {
            this.ID = id;
            this.HOST_BLOCK = hostBlock;
            this.TRANSLATIONS = translations;
        }

        public String blockId() {
            return "infested_" + this.ID + "_coral_block";
        }

        public Block blockSupplier() {
            return new UnderwaterSilverfishBlock(this.HOST_BLOCK);
        }

        public Block hostBlock() {
            return this.HOST_BLOCK;
        }

        public Block block() {
            return (Block)SMBlocks.INFESTED_CORAL.get(this.ordinal()).get();
        }

        private String[] getTranslations(String langKey) {
            return this.TRANSLATIONS.apply(langKey);
        }

        private static String[] getTranslationsFor(String langKey) {
            for (Type type : Type.values()) {
                if (!langKey.contains(type.ID)) continue;
                return type.getTranslations(langKey);
            }
            return References.translations(langKey, "", "", "", "", "", "", "");
        }

        public static Type next(RandomSource random) {
            return Type.values()[random.m_188503_(Type.values().length)];
        }
    }
}

