/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.block;

import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import fathertoast.specialmobs.common.util.References;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;

public class MeltingIceBlock
extends IceBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty HAS_WATER = BooleanProperty.m_61465_((String)"has_water");

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Melting Ice", "", "", "", "", "", "");
    }

    public static BlockState getState(Level level, BlockPos pos) {
        BlockState currentBlock = level.m_8055_(pos);
        return (BlockState)((Block)SMBlocks.MELTING_ICE.get()).m_49966_().m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(currentBlock.m_60713_(Blocks.f_50449_) || currentBlock.m_60734_() == Blocks.f_49990_ && (Integer)currentBlock.m_61143_((Property)LiquidBlock.f_54688_) == 0));
    }

    public static void scheduleFirstTick(Level level, BlockPos pos, RandomSource random) {
        level.m_186460_(pos, (Block)SMBlocks.MELTING_ICE.get(), Mth.m_216271_((RandomSource)random, (int)60, (int)120));
    }

    private void scheduleTick(Level level, BlockPos pos, RandomSource random) {
        int darkness = 15 - MeltingIceBlock.getLight(level, pos);
        int solidNeighbors = 0;
        BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!level.m_8055_((BlockPos)neighborPos.m_122159_((Vec3i)pos, direction)).m_280296_()) continue;
            ++solidNeighbors;
        }
        int delay = 5 + darkness + 10 * solidNeighbors;
        level.m_186460_(pos, (Block)this, Mth.m_216271_((RandomSource)random, (int)delay, (int)(delay << 1)));
    }

    private static int getLight(Level level, BlockPos pos) {
        int highestLight = 0;
        BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            int neighborLight = level.m_45517_(LightLayer.BLOCK, (BlockPos)neighborPos.m_122159_((Vec3i)pos, direction));
            if (neighborLight > 14) {
                return 15;
            }
            if (neighborLight <= highestLight) continue;
            highestLight = neighborLight;
        }
        return highestLight;
    }

    public MeltingIceBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_).m_60918_(SoundType.f_56744_).m_60955_().m_60977_().m_60911_(0.98f).m_60978_(0.5f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{HAS_WATER});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
        MeltingIceBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
        if (tool.getEnchantmentLevel(Enchantments.f_44985_) == 0) {
            this.m_54168_(state, level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.m_213897_(state, world, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.canMelt((Level)level, pos)) {
            if (this.slightlyMelt(state, (Level)level, pos, random)) {
                BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
                this.trySlightlyMelt((Level)level, (BlockPos)neighborPos.m_122159_((Vec3i)pos, Direction.DOWN), random);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.trySlightlyMelt((Level)level, (BlockPos)neighborPos.m_122159_((Vec3i)pos, direction), random);
                }
            }
        } else {
            this.scheduleTick((Level)level, pos, random);
        }
    }

    private boolean canMelt(Level level, BlockPos pos) {
        if (MeltingIceBlock.getLight(level, pos) > 13) {
            return true;
        }
        BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (level.m_8055_((BlockPos)neighborPos.m_122159_((Vec3i)pos, direction)).m_60713_((Block)this)) continue;
            return !level.m_8055_((BlockPos)neighborPos.m_122159_((Vec3i)pos, Direction.UP)).m_60713_((Block)this) || level.m_8055_((BlockPos)neighborPos.m_122159_((Vec3i)pos, Direction.DOWN)).m_60795_();
        }
        return false;
    }

    private void trySlightlyMelt(Level level, BlockPos pos, RandomSource random) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)this) && this.canMelt(level, pos)) {
            this.slightlyMelt(state, level, pos, random);
        }
    }

    private boolean slightlyMelt(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            this.scheduleTick(level, pos, random);
            return false;
        }
        this.m_54168_(state, level, pos);
        return true;
    }

    protected void m_54168_(BlockState state, Level level, BlockPos pos) {
        if (level.m_6042_().f_63857_() || !((Boolean)state.m_61143_((Property)HAS_WATER)).booleanValue()) {
            level.m_7471_(pos, false);
        } else {
            level.m_46597_(pos, Blocks.f_49990_.m_49966_());
            level.m_46586_(pos, Blocks.f_49990_, pos);
        }
    }
}

