/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.register.SMBiomeMods;
import fathertoast.specialmobs.common.entity.creeper.DrowningCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper.EnderCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper.FireCreeperEntity;
import fathertoast.specialmobs.common.entity.skeleton.PirateSkeletonEntity;
import fathertoast.specialmobs.common.entity.slime.BlueberrySlimeEntity;
import fathertoast.specialmobs.common.entity.spider.FireSpiderEntity;
import fathertoast.specialmobs.common.entity.zombie.FireZombieEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public record NaturalAddSpawnModifier(String comment) implements BiomeModifier
{
    public static final Codec<NaturalAddSpawnModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("_comment").forGetter(NaturalAddSpawnModifier::comment)).apply((Applicative)builder, NaturalAddSpawnModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!Config.MAIN.GENERAL.enableNaturalSpawning.get()) {
            return;
        }
        if (phase == BiomeModifier.Phase.ADD) {
            NaturalAddSpawnModifier.addCopiedSpawns(builder);
            NaturalAddSpawnModifier.addBiomeCategorySpawns((MobSpawnSettings.Builder)builder.getMobSpawnSettings(), biome, ForgeRegistries.BIOMES.getKey((Object)((Biome)biome.m_203334_())));
        }
    }

    private static void addCopiedSpawns(ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        NaturalAddSpawnModifier.addCopiedSpawns(builder, EntityType.f_20479_, EntityType.f_20554_, Config.MAIN.NATURAL_SPAWNING.caveSpiderSpawnMultiplier.get());
        NaturalAddSpawnModifier.addCopiedSpawns(builder, EntityType.f_20566_, (EntityType)EnderCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.enderCreeperSpawnMultiplier.get());
    }

    private static void addCopiedSpawns(ModifiableBiomeInfo.BiomeInfo.Builder builder, EntityType<?> typeToCopy, EntityType<?> typeToAdd, double multi) {
        if (multi <= 0.0) {
            return;
        }
        ArrayList<MobSpawnSettings.SpawnerData> spawnersToCopy = new ArrayList<MobSpawnSettings.SpawnerData>();
        List spawners = builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER);
        for (MobSpawnSettings.SpawnerData spawner : spawners) {
            if (spawner.f_48404_ == typeToAdd && spawner.m_142631_().m_146281_() > 0) {
                return;
            }
            if (spawner.f_48404_ != typeToCopy || spawner.m_142631_().m_146281_() <= 0) continue;
            spawnersToCopy.add(spawner);
        }
        if (!spawnersToCopy.isEmpty()) {
            for (MobSpawnSettings.SpawnerData spawner : spawnersToCopy) {
                NaturalAddSpawnModifier.addSpawn((MobSpawnSettings.Builder)builder.getMobSpawnSettings(), typeToAdd, (int)Math.max(1.0, (double)Mth.m_14143_((float)spawner.m_142631_().m_146281_()) * multi), spawner.f_48405_, spawner.f_48406_);
            }
            MobSpawnSettings.MobSpawnCost costsToCopy = builder.getMobSpawnSettings().getCost(typeToCopy);
            if (costsToCopy != null) {
                builder.getMobSpawnSettings().m_48370_(typeToAdd, costsToCopy.f_48386_(), costsToCopy.f_48385_());
            }
        }
    }

    private static void addBiomeCategorySpawns(MobSpawnSettings.Builder builder, Holder<Biome> holder, @Nullable ResourceLocation name) {
        if (holder.m_203656_(BiomeTags.f_207603_)) {
            NaturalAddSpawnModifier.addSpawn(builder, (EntityType)DrowningCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.drowningCreeperOceanWeight.get());
            NaturalAddSpawnModifier.addSpawn(builder, (EntityType)BlueberrySlimeEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.blueberrySlimeOceanWeight.get());
            NaturalAddSpawnModifier.addSpawn(builder, (EntityType)PirateSkeletonEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.pirateSkeletonOceanWeight.get());
        } else if (holder.m_203656_(BiomeTags.f_207605_)) {
            NaturalAddSpawnModifier.addSpawn(builder, (EntityType)DrowningCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.drowningCreeperRiverWeight.get());
            NaturalAddSpawnModifier.addSpawn(builder, (EntityType)BlueberrySlimeEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.blueberrySlimeRiverWeight.get());
        } else if (holder.m_203656_(BiomeTags.f_207612_)) {
            NaturalAddSpawnModifier.addNetherSpawns(builder, name);
        }
    }

    private static void addNetherSpawns(MobSpawnSettings.Builder builder, @Nullable ResourceLocation name) {
        if (NaturalAddSpawnModifier.isBiome(name, (ResourceKey<Biome>)Biomes.f_48201_)) {
            return;
        }
        if (NaturalAddSpawnModifier.isBiome(name, (ResourceKey<Biome>)Biomes.f_48199_)) {
            NaturalAddSpawnModifier.addSpawn(builder, EntityType.f_20497_, Config.MAIN.NATURAL_SPAWNING.witherSkeletonSoulSandValleyWeight.get(), 5, 5, 0.7, 0.15);
            return;
        }
        NaturalAddSpawnModifier.addSpawn(builder, EntityType.f_20497_, Config.MAIN.NATURAL_SPAWNING.witherSkeletonNetherWeight.get(), 5, 5);
        if (NaturalAddSpawnModifier.isBiome(name, (ResourceKey<Biome>)Biomes.f_48175_)) {
            NaturalAddSpawnModifier.addSpawn(builder, EntityType.f_20551_, Config.MAIN.NATURAL_SPAWNING.blazeBasaltDeltasWeight.get(), 2, 3);
        } else {
            NaturalAddSpawnModifier.addSpawn(builder, EntityType.f_20551_, Config.MAIN.NATURAL_SPAWNING.blazeNetherWeight.get(), 2, 3);
        }
        NaturalAddSpawnModifier.addSpawn(builder, (EntityType)FireCreeperEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.fireCreeperNetherWeight.get(), 4, 4);
        NaturalAddSpawnModifier.addSpawn(builder, (EntityType)FireZombieEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.fireZombieNetherWeight.get(), 4, 4);
        NaturalAddSpawnModifier.addSpawn(builder, (EntityType)FireSpiderEntity.SPECIES.entityType.get(), Config.MAIN.NATURAL_SPAWNING.fireSpiderNetherWeight.get(), 4, 4);
    }

    private static boolean isBiome(@Nullable ResourceLocation name, ResourceKey<Biome> biome) {
        return biome.m_135782_().equals((Object)name);
    }

    private static void addSpawn(MobSpawnSettings.Builder builder, EntityType<?> entity, int weight) {
        NaturalAddSpawnModifier.addSpawn(builder, entity, weight, 1, 1);
    }

    private static void addSpawn(MobSpawnSettings.Builder builder, EntityType<?> entity, int weight, int minCount, int maxCount) {
        if (weight > 0) {
            builder.m_48376_(entity.m_20674_(), new MobSpawnSettings.SpawnerData(entity, weight, minCount, maxCount));
        }
    }

    private static void addSpawn(MobSpawnSettings.Builder builder, EntityType<?> entity, int weight, int minCount, int maxCount, double charge, double budget) {
        if (weight > 0) {
            builder.m_48376_(entity.m_20674_(), new MobSpawnSettings.SpawnerData(entity, weight, minCount, maxCount));
            builder.m_48370_(entity, charge, budget);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SMBiomeMods.NATURAL_ADD_SPAWN.get();
    }
}

