/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.bestiary;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.family.CreeperFamilyConfig;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import fathertoast.specialmobs.common.config.family.GhastFamilyConfig;
import fathertoast.specialmobs.common.config.family.SilverfishFamilyConfig;
import fathertoast.specialmobs.common.config.family.SkeletonFamilyConfig;
import fathertoast.specialmobs.common.config.family.SlimeFamilyConfig;
import fathertoast.specialmobs.common.config.family.WitchFamilyConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.util.AnnotationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.RegistryObject;

public class MobFamily<T extends Mob, V extends FamilyConfig> {
    private static final ArrayList<MobFamily<?, ?>> FAMILY_LIST = new ArrayList();
    private static final List<Species<?>> SPECIES_LIST;
    private static final Map<EntityType<?>, MobFamily<?, ?>> TYPE_TO_FAMILY_MAP;
    public static final MobFamily<Creeper, CreeperFamilyConfig> CREEPER;
    public static final MobFamily<Zombie, FamilyConfig> ZOMBIE;
    public static final MobFamily<Drowned, FamilyConfig> DROWNED;
    public static final MobFamily<ZombifiedPiglin, FamilyConfig> ZOMBIFIED_PIGLIN;
    public static final MobFamily<AbstractSkeleton, SkeletonFamilyConfig> SKELETON;
    public static final MobFamily<AbstractSkeleton, SkeletonFamilyConfig> WITHER_SKELETON;
    public static final MobFamily<Slime, SlimeFamilyConfig> SLIME;
    public static final MobFamily<MagmaCube, FamilyConfig> MAGMA_CUBE;
    public static final MobFamily<Spider, FamilyConfig> SPIDER;
    public static final MobFamily<CaveSpider, FamilyConfig> CAVE_SPIDER;
    public static final MobFamily<Silverfish, SilverfishFamilyConfig> SILVERFISH;
    public static final MobFamily<EnderMan, FamilyConfig> ENDERMAN;
    public static final MobFamily<Witch, WitchFamilyConfig> WITCH;
    public static final MobFamily<Ghast, GhastFamilyConfig> GHAST;
    public static final MobFamily<Blaze, FamilyConfig> BLAZE;
    public final String name;
    public final String configName;
    public final int eggBaseColor;
    public final EntityType<?>[] replaceableTypes;
    public final Species<? extends T> vanillaReplacement;
    public final Species<? extends T>[] variants;
    public final V config;
    private Boolean hasAnyGiants;

    public static void initBestiary() {
    }

    public static List<MobFamily<?, ?>> getAll() {
        return Collections.unmodifiableList(FAMILY_LIST);
    }

    public static List<Species<?>> getAllSpecies() {
        return SPECIES_LIST;
    }

    @Nullable
    public static MobFamily<?, ?> getReplacementFamily(Entity entity) {
        return TYPE_TO_FAMILY_MAP.get(entity.m_6095_());
    }

    private MobFamily(BiFunction<ConfigManager, MobFamily<?, ?>, V> configSupplier, String familyName, String readableName, int eggColor, EntityType<?>[] replaceable, String ... variantNames) {
        this.name = familyName;
        this.configName = readableName.toLowerCase(Locale.ROOT);
        this.eggBaseColor = eggColor;
        this.replaceableTypes = replaceable;
        if (replaceable.length < 1) {
            throw new IllegalArgumentException(familyName + " family must have at least one replaceable type!");
        }
        String packageRoot = "fathertoast.specialmobs.common.entity." + this.name.toLowerCase();
        this.vanillaReplacement = new Species(this, packageRoot, null);
        this.variants = new Species[variantNames.length];
        for (int i = 0; i < this.variants.length; ++i) {
            this.variants[i] = new Species(this, packageRoot, variantNames[i]);
        }
        this.config = (FamilyConfig)((Object)configSupplier.apply(Config.MANAGER, this));
        ((FamilyConfig)((Object)this.config)).SPEC.initialize();
        FAMILY_LIST.add(this);
    }

    public Species<? extends T> nextVariant(Level level, @Nullable BlockPos pos, @Nullable Predicate<Species<?>> selector) {
        return this.nextVariant(level, pos, selector, this.vanillaReplacement);
    }

    public Species<? extends T> nextVariant(Level level, @Nullable BlockPos pos, @Nullable Predicate<Species<?>> selector, Species<? extends T> fallback) {
        Species species = (Species)((FamilyConfig)((Object)this.config)).GENERAL.specialVariantList.next(level.f_46441_, level, pos, selector);
        return species == null ? fallback : species;
    }

    public boolean hasAnyGiants() {
        if (this.hasAnyGiants == null) {
            this.hasAnyGiants = false;
            for (Species<T> species : this.variants) {
                if (species.isNotGiant()) continue;
                this.hasAnyGiants = true;
                break;
            }
        }
        return this.hasAnyGiants;
    }

    static {
        CREEPER = new MobFamily(CreeperFamilyConfig::new, "Creeper", "creepers", 894731, new EntityType[]{EntityType.f_20558_}, "Dark", "Death", "Dirt", "Doom", "Drowning", "Ender", "Fire", "Gravel", "Jumping", "Lightning", "Mini", "Sand", "Scope", "Snow", "Skeleton", "Splitting");
        ZOMBIE = new MobFamily(FamilyConfig::newLessSpecial, "Zombie", "zombies", 44975, new EntityType[]{EntityType.f_20501_, EntityType.f_20458_}, "Brute", "Fire", "Fishing", "Frozen", "Giant", "Hungry", "Husk", "MadScientist", "Plague");
        DROWNED = new MobFamily(FamilyConfig::new, "Drowned", "drowned", 9433559, new EntityType[]{EntityType.f_20562_}, "Abyssal", "Brute", "Fishing", "Frozen", "Giant", "Hungry", "Knight", "Plague", "Tropical");
        ZOMBIFIED_PIGLIN = new MobFamily(FamilyConfig::new, "ZombifiedPiglin", "zombified piglins", 15373203, new EntityType[]{EntityType.f_20531_}, "Brute", "Fishing", "Giant", "Hungry", "Knight", "Plague", "Vampire");
        SKELETON = new MobFamily(SkeletonFamilyConfig::new, "Skeleton", "skeletons", 0xC1C1C1, new EntityType[]{EntityType.f_20524_, EntityType.f_20481_}, "Brute", "Fire", "Gatling", "Giant", "Knight", "Ninja", "Pirate", "Poison", "Sniper", "Spitfire", "Stray", "Weathered");
        WITHER_SKELETON = new MobFamily(SkeletonFamilyConfig::new, "WitherSkeleton", "wither skeletons", 0x141414, new EntityType[]{EntityType.f_20497_}, "Brute", "Gatling", "Giant", "Knight", "Ninja", "Sniper", "Spitfire");
        SLIME = new MobFamily(SlimeFamilyConfig::new, "Slime", "slimes", 5349438, new EntityType[]{EntityType.f_20526_}, "Blackberry", "Blueberry", "Caramel", "Frozen", "Grape", "Lemon", "Potion", "Strawberry", "Watermelon");
        MAGMA_CUBE = new MobFamily(FamilyConfig::newMoreSpecial, "MagmaCube", "magma cubes", 0x340000, new EntityType[]{EntityType.f_20468_}, "Bouncing", "Hardened", "Sticky", "Volatile");
        SPIDER = new MobFamily(FamilyConfig::newMoreSpecial, "Spider", "spiders", 3419431, new EntityType[]{EntityType.f_20479_}, "Baby", "Desert", "Fire", "Flying", "Giant", "Hungry", "Mother", "Pale", "Poison", "Water", "Web", "Witch");
        CAVE_SPIDER = new MobFamily(FamilyConfig::newMoreSpecial, "CaveSpider", "cave spiders", 803406, new EntityType[]{EntityType.f_20554_}, "Baby", "Desert", "Fire", "Flying", "Mother", "Pale", "Water", "Web", "Witch");
        SILVERFISH = new MobFamily(SilverfishFamilyConfig::new, "Silverfish", "silverfish", 0x6E6E6E, new EntityType[]{EntityType.f_20523_}, "Albino", "Blinding", "Desiccated", "Fire", "Fishing", "Flying", "Poison", "Puffer", "Tough");
        ENDERMAN = new MobFamily(FamilyConfig::new, "Enderman", "endermen", 0x161616, new EntityType[]{EntityType.f_20566_}, "Blinding", "Flame", "Icy", "Lightning", "Mini", "Mirage", "Runic", "Thief");
        WITCH = new MobFamily(WitchFamilyConfig::new, "Witch", "witches", 0x340000, new EntityType[]{EntityType.f_20495_}, "Domination", "Ice", "Shadows", "Undead", "Wilds", "Wind");
        GHAST = new MobFamily(GhastFamilyConfig::new, "Ghast", "ghasts", 0xF9F9F9, new EntityType[]{EntityType.f_20453_}, "Baby", "CorporealShift", "Fighter", "King", "Queen", "Slab", "Unholy");
        BLAZE = new MobFamily(FamilyConfig::new, "Blaze", "blazes", 16167425, new EntityType[]{EntityType.f_20551_}, "Armored", "Cinder", "Conflagration", "Ember", "Hellfire", "Inferno", "Jolt", "Wildfire");
        FAMILY_LIST.trimToSize();
        HashMap classToFamilyMap = new HashMap();
        ArrayList allSpecies = new ArrayList();
        for (MobFamily<?, ?> family : FAMILY_LIST) {
            for (EntityType<?> replaceable : family.replaceableTypes) {
                classToFamilyMap.put(replaceable, family);
            }
            allSpecies.add(family.vanillaReplacement);
            allSpecies.addAll(Arrays.asList(family.variants));
        }
        allSpecies.trimToSize();
        TYPE_TO_FAMILY_MAP = Collections.unmodifiableMap(classToFamilyMap);
        SPECIES_LIST = Collections.unmodifiableList(allSpecies);
    }

    public static class Species<T extends Mob> {
        private static final Map<EntityType<?>, Species<?>> TYPE_TO_SPECIES_MAP = new HashMap();
        public final MobFamily<? super T, ?> family;
        public final String specialVariantName;
        public final String name;
        public final Class<T> entityClass;
        public final BestiaryInfo bestiaryInfo;
        public final RegistryObject<EntityType<T>> entityType;
        public final RegistryObject<ForgeSpawnEggItem> spawnEgg;
        public final SpeciesConfig config;
        private Boolean isNotGiant;
        private float heightScale = -1.0f;

        @Nullable
        public static Species<?> of(EntityType<?> entityType) {
            return TYPE_TO_SPECIES_MAP.get(entityType);
        }

        private Species(MobFamily<? super T, ?> parentFamily, String packageRoot, @Nullable String variantName) {
            boolean vanillaReplacement = variantName == null;
            this.family = parentFamily;
            this.specialVariantName = variantName;
            this.name = vanillaReplacement ? parentFamily.name : variantName + parentFamily.name;
            this.entityClass = this.findClass(vanillaReplacement ? "%s._Special%sEntity" : "%s.%sEntity", packageRoot);
            EntityType.Builder<T> entityTypeBuilder = this.makeEntityTypeBuilder(parentFamily.replaceableTypes[0]);
            this.bestiaryInfo = AnnotationHelper.getBestiaryInfo(this, BestiaryInfo.of(this, entityTypeBuilder)).build();
            this.entityType = SMEntities.register(this.name.toLowerCase(Locale.ROOT), entityTypeBuilder);
            this.spawnEgg = SMItems.registerSpawnEgg(this.entityType, parentFamily.eggBaseColor, this.bestiaryInfo.eggSpotsColor);
            this.config = AnnotationHelper.createConfig(Config.MANAGER, this);
            this.config.SPEC.initialize();
            AnnotationHelper.injectSpeciesReference(this);
            AnnotationHelper.verifySpeciesSupplier(this);
        }

        private Class<T> findClass(String format, String packageRoot) {
            try {
                return Class.forName(String.format(format, packageRoot, this.name));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Failed to find entity class for mob species " + this.name, ex);
            }
        }

        private EntityType.Builder<T> makeEntityTypeBuilder(EntityType<?> original) {
            EntityType.EntityFactory factory = AnnotationHelper.getEntityFactory(this);
            EntityType.Builder clone = EntityType.Builder.m_20704_(factory, (MobCategory)original.m_20674_());
            if (!original.m_20654_()) {
                clone.m_20698_();
            }
            if (!original.m_20584_()) {
                clone.m_20716_();
            }
            if (original.m_20672_()) {
                clone.m_20719_();
            }
            if (original.m_20673_()) {
                clone.m_20720_();
            }
            return clone.m_20699_(original.m_20678_(), original.m_20679_()).m_20714_((Block[])original.f_20537_.toArray((Object[])new Block[0])).m_20702_(original.m_20681_()).m_20717_(original.m_20682_()).setShouldReceiveVelocityUpdates(original.m_20683_());
        }

        public void registerSpawnPlacement() {
            TYPE_TO_SPECIES_MAP.put((EntityType)this.entityType.get(), this);
            AnnotationHelper.registerSpawnPlacement(this);
        }

        public String getConfigName() {
            return (String)(this.specialVariantName == null ? "vanilla replacement " : ConfigUtil.camelCaseToLowerSpace((String)this.specialVariantName) + " ") + this.family.configName;
        }

        public String getConfigNameSingular() {
            return (String)(this.specialVariantName == null ? "vanilla replacement " : ConfigUtil.camelCaseToLowerSpace((String)this.specialVariantName) + " ") + ConfigUtil.camelCaseToLowerSpace((String)this.family.name);
        }

        public boolean isNotGiant() {
            if (this.isNotGiant == null) {
                this.isNotGiant = Mth.m_14167_((float)((EntityType)this.entityType.get()).m_20679_()) <= Mth.m_14167_((float)this.family.replaceableTypes[0].m_20679_());
            }
            return this.isNotGiant;
        }

        public float getHeightScale() {
            if (this.heightScale < 0.0f) {
                this.heightScale = ((EntityType)this.entityType.get()).m_20679_() / this.family.replaceableTypes[0].m_20679_();
            }
            return this.heightScale;
        }
    }
}

